/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.auth.AccessControl;
import io.crate.auth.AuthSettings;
import io.crate.auth.Credentials;
import io.crate.auth.Protocol;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.protocols.SSL;
import io.crate.protocols.http.Headers;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.rest.action.HttpError;
import io.crate.rest.action.RestBulkRowCountReceiver;
import io.crate.rest.action.RestResultSetReceiver;
import io.crate.rest.action.RestRowCountReceiver;
import io.crate.rest.action.ResultToXContentBuilder;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.session.DescribeResult;
import io.crate.session.ResultReceiver;
import io.crate.session.Session;
import io.crate.session.Sessions;
import io.crate.session.parser.SQLRequestParseContext;
import io.crate.session.parser.SQLRequestParser;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SqlHttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LogManager.getLogger(SqlHttpHandler.class);
    private static final String REQUEST_HEADER_SCHEMA = "Default-Schema";
    private final Settings settings;
    private final Sessions sessions;
    private final Function<String, CircuitBreaker> circuitBreakerProvider;
    private final Roles roles;
    private final Netty4CorsConfig corsConfig;
    private final boolean checkJwtProperties;
    private Session session;

    public SqlHttpHandler(Settings settings, Sessions sessions, Function<String, CircuitBreaker> circuitBreakerProvider, Roles roles, Netty4CorsConfig corsConfig) {
        super(false);
        this.settings = settings;
        this.sessions = sessions;
        this.circuitBreakerProvider = circuitBreakerProvider;
        this.roles = roles;
        this.corsConfig = corsConfig;
        this.checkJwtProperties = settings.get(AuthSettings.AUTH_HOST_BASED_JWT_ISS_SETTING.getKey()) == null;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (request.uri().startsWith("/_sql")) {
            Session session = this.ensureSession(new ConnectionProperties(null, Netty4HttpServerTransport.getRemoteAddress(ctx.channel()), Protocol.HTTP, SSL.getSession(ctx.channel())), request);
            Map parameters = new QueryStringDecoder(request.uri()).parameters();
            ByteBuf content = request.content();
            this.handleSQLRequest(session, content, SqlHttpHandler.paramContainFlag(parameters, "types")).whenComplete((result, t) -> {
                try {
                    this.sendResponse(session, ctx, request, parameters, (XContentBuilder)result, (Throwable)t);
                }
                catch (Throwable ex) {
                    LOGGER.error("Error sending response", ex);
                    throw ex;
                }
                finally {
                    request.release();
                }
            });
        } else {
            ctx.fireChannelRead((Object)request);
        }
    }

    private static boolean paramContainFlag(Map<String, List<String>> parameters, String flag) {
        List<String> values = parameters.get(flag);
        return values != null && (values.equals(Collections.singletonList("")) || values.equals(Collections.singletonList("true")));
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        super.channelUnregistered(ctx);
    }

    private void sendResponse(Session session, ChannelHandlerContext ctx, FullHttpRequest request, Map<String, List<String>> parameters, XContentBuilder result, @Nullable Throwable t) {
        DefaultFullHttpResponse resp;
        ByteBuf content;
        HttpVersion httpVersion = request.protocolVersion();
        if (t == null) {
            content = Netty4Utils.toByteBuf(BytesReference.bytes(result));
            resp = new DefaultFullHttpResponse(httpVersion, HttpResponseStatus.OK, content);
            resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)result.contentType().mediaType());
        } else {
            String mediaType;
            CoordinatorSessionSettings sessionSettings = session.sessionSettings();
            AccessControl accessControl = this.roles.getAccessControl(sessionSettings.authenticatedUser(), sessionSettings.sessionUser());
            Throwable throwable = SQLExceptions.prepareForClientTransmission(accessControl, t);
            HttpError httpError = HttpError.fromThrowable(throwable);
            boolean includeErrorTrace = SqlHttpHandler.paramContainFlag(parameters, "error_trace");
            try (XContentBuilder contentBuilder = httpError.toXContent(includeErrorTrace);){
                content = Netty4Utils.toByteBuf(BytesReference.bytes(contentBuilder));
                mediaType = contentBuilder.contentType().mediaType();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            resp = new DefaultFullHttpResponse(httpVersion, httpError.httpResponseStatus(), content);
            resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
        }
        Netty4CorsHandler.setCorsResponseHeaders((HttpRequest)request, (HttpResponse)resp, this.corsConfig);
        resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(content.readableBytes()));
        boolean closeConnection = Headers.isCloseConnection(request);
        ChannelPromise promise = ctx.newPromise();
        if (closeConnection) {
            promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            Headers.setKeepAlive(httpVersion, (FullHttpResponse)resp);
        }
        ctx.writeAndFlush((Object)resp, promise);
    }

    private CompletableFuture<XContentBuilder> handleSQLRequest(Session session, ByteBuf content, boolean includeTypes) {
        SQLRequestParseContext parseContext;
        try {
            parseContext = SQLRequestParser.parseSource(Netty4Utils.toBytesReference(content));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        List<Object> args = parseContext.args();
        List<List<Object>> bulkArgs = parseContext.bulkArgs();
        if (SqlHttpHandler.bothProvided(args, bulkArgs)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("request body contains args and bulk_args. It's forbidden to provide both"));
        }
        try {
            if (args != null || bulkArgs == null) {
                return this.executeSimpleRequest(session, parseContext.stmt(), args, includeTypes);
            }
            return this.executeBulkRequest(session, parseContext.stmt(), bulkArgs);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @VisibleForTesting
    Session ensureSession(ConnectionProperties connectionProperties, FullHttpRequest request) {
        String defaultSchema = request.headers().get(REQUEST_HEADER_SCHEMA);
        Role authenticatedUser = this.userFromAuthHeader(request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
        Session session = this.session;
        if (session == null) {
            session = this.sessions.newSession(connectionProperties, defaultSchema, authenticatedUser);
        } else if (!session.sessionSettings().authenticatedUser().equals(authenticatedUser)) {
            session.close();
            session = this.sessions.newSession(connectionProperties, defaultSchema, authenticatedUser);
        }
        this.session = session;
        return session;
    }

    private CompletableFuture<XContentBuilder> executeSimpleRequest(Session session, String stmt, List<Object> args, boolean includeTypes) throws IOException {
        ResultReceiver<XContentBuilder> resultReceiver;
        long startTimeInNs = System.nanoTime();
        session.parse("", stmt, Collections.emptyList());
        session.bind("", "", args == null ? Collections.emptyList() : args, null);
        DescribeResult description = session.describe('P', "");
        List<Symbol> resultFields = description.getFields();
        if (resultFields == null) {
            resultReceiver = new RestRowCountReceiver(JsonXContent.builder(), startTimeInNs, includeTypes);
        } else {
            CircuitBreaker breaker = this.circuitBreakerProvider.apply("query");
            BlockBasedRamAccounting ramAccounting = new BlockBasedRamAccounting(b -> breaker.addEstimateBytesAndMaybeBreak(b, "http-result"), 0x200000);
            resultReceiver = new RestResultSetReceiver(new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, (OutputStream)new RamAccountingOutputStream((RamAccounting)ramAccounting)), resultFields, description.getFieldNames(), startTimeInNs, includeTypes);
            resultReceiver.completionFuture().whenComplete((arg_0, arg_1) -> SqlHttpHandler.lambda$executeSimpleRequest$1((RamAccounting)ramAccounting, arg_0, arg_1));
        }
        session.execute("", 0, resultReceiver);
        return session.sync(false).thenCompose(ignored -> resultReceiver.completionFuture());
    }

    private CompletableFuture<XContentBuilder> executeBulkRequest(Session session, String stmt, List<List<Object>> bulkArgs) {
        DescribeResult describeResult;
        long startTimeInNs = System.nanoTime();
        session.parse("", stmt, Collections.emptyList());
        RestBulkRowCountReceiver.Result[] results = new RestBulkRowCountReceiver.Result[bulkArgs.size()];
        for (int i = 0; i < bulkArgs.size(); ++i) {
            session.bind("", "", bulkArgs.get(i), null);
            RestBulkRowCountReceiver resultReceiver = new RestBulkRowCountReceiver(results, i);
            session.execute("", 0, resultReceiver);
        }
        if (results.length > 0 && (describeResult = session.describe('P', "")).getFields() != null) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException("Bulk operations for statements that return result sets is not supported"));
        }
        CoordinatorSessionSettings sessionSettings = session.sessionSettings();
        AccessControl accessControl = this.roles.getAccessControl(sessionSettings.authenticatedUser(), sessionSettings.sessionUser());
        return session.sync(true).thenApply(object -> {
            try {
                return ResultToXContentBuilder.builder(JsonXContent.builder()).cols(Collections.emptyList()).duration(startTimeInNs).bulkRows(results, accessControl).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    Role userFromAuthHeader(@Nullable String authHeaderValue) {
        try (Credentials credentials = Headers.extractCredentialsFromHttpAuthHeader(authHeaderValue);){
            String username;
            Role role;
            Predicate<Role> rolePredicate = credentials.matchByToken(this.checkJwtProperties);
            if (rolePredicate != null && (role = this.roles.findUser(rolePredicate)) != null) {
                credentials.setUsername(role.name());
            }
            if ((username = credentials.username()) == null || username.isEmpty()) {
                username = AuthSettings.AUTH_TRUST_HTTP_DEFAULT_HEADER.get(this.settings);
            }
            Role role2 = this.roles.findUser(username);
            return role2;
        }
    }

    private static boolean bothProvided(@Nullable List<Object> args, @Nullable List<List<Object>> bulkArgs) {
        return args != null && !args.isEmpty() && bulkArgs != null && !bulkArgs.isEmpty();
    }

    private static /* synthetic */ void lambda$executeSimpleRequest$1(RamAccounting ramAccounting, XContentBuilder result, Throwable error) {
        ramAccounting.close();
    }

    static final class RamAccountingOutputStream
    extends ByteArrayOutputStream {
        private final RamAccounting ramAccounting;

        public RamAccountingOutputStream(RamAccounting ramAccounting) {
            this.ramAccounting = ramAccounting;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.ramAccounting.addBytes((long)len);
            super.write(b, off, len);
        }

        @Override
        public void write(int b) {
            this.ramAccounting.addBytes(1L);
            super.write(b);
        }

        @Override
        public void close() throws IOException {
            this.ramAccounting.release();
            super.close();
        }
    }
}

