/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.common.collections.Sets;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.role.GrantedRole;
import io.crate.role.JwtProperties;
import io.crate.role.Permission;
import io.crate.role.Policy;
import io.crate.role.Privilege;
import io.crate.role.RolePrivileges;
import io.crate.role.Securable;
import io.crate.role.SecureHash;
import io.crate.role.Subject;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public class Role
implements Writeable {
    public static final Role CRATE_USER = new Role("crate", new RolePrivileges(Set.of()), Set.of(), new Properties(true, null, null, Map.of()), true);
    private final String name;
    private final RolePrivileges privileges;
    private final Set<GrantedRole> grantedRoles;
    private final boolean isSuperUser;
    private final Properties properties;

    public Role(String name, boolean login, Set<Privilege> privileges, Set<GrantedRole> grantedRoles, @Nullable SecureHash password, @Nullable JwtProperties jwtProperties, Map<String, Object> sessionSettings) {
        this(name, new RolePrivileges(privileges), grantedRoles, new Properties(login, password, jwtProperties, sessionSettings), false);
    }

    private Role(String name, RolePrivileges privileges, Set<GrantedRole> grantedRoles, Properties properties, boolean isSuperUser) {
        if (!properties.login) {
            assert (properties.password == null) : "Cannot create a Role with password";
            assert (!isSuperUser) : "Cannot create a Role which is superUser";
        }
        this.name = name;
        this.privileges = privileges;
        this.grantedRoles = Collections.unmodifiableSet(grantedRoles);
        this.isSuperUser = isSuperUser;
        this.properties = properties;
    }

    public Role(StreamInput in) throws IOException {
        this.name = in.readString();
        int privSize = in.readVInt();
        ArrayList<Privilege> privilegesList = new ArrayList<Privilege>(privSize);
        for (int i = 0; i < privSize; ++i) {
            privilegesList.add(new Privilege(in));
        }
        this.privileges = new RolePrivileges(privilegesList);
        int grantedRolesSize = in.readVInt();
        HashSet grantedRoleSet = HashSet.newHashSet(grantedRolesSize);
        for (int i = 0; i < grantedRolesSize; ++i) {
            grantedRoleSet.add(new GrantedRole(in));
        }
        this.grantedRoles = Collections.unmodifiableSet(grantedRoleSet);
        this.isSuperUser = false;
        this.properties = new Properties(in);
    }

    public Role with(RolePrivileges privileges) {
        return new Role(this.name, privileges, this.grantedRoles, this.properties, this.isSuperUser);
    }

    public Role with(Set<GrantedRole> grantedRoles) {
        return new Role(this.name, this.privileges, grantedRoles, this.properties, this.isSuperUser);
    }

    public Role with(@Nullable SecureHash password, @Nullable JwtProperties jwtProperties, Map<String, Object> sessionSettings) {
        return new Role(this.name, this.privileges, this.grantedRoles, new Properties(this.properties.login, password, jwtProperties, sessionSettings), this.isSuperUser);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public SecureHash password() {
        return this.properties.password();
    }

    public boolean isUser() {
        return this.properties.login();
    }

    @Nullable
    public JwtProperties jwtProperties() {
        return this.properties.jwtProperties();
    }

    public Map<String, Object> sessionSettings() {
        return this.properties.sessionSettings();
    }

    public boolean isSuperUser() {
        return this.isSuperUser;
    }

    public RolePrivileges privileges() {
        return this.privileges;
    }

    public Set<GrantedRole> grantedRoles() {
        return this.grantedRoles;
    }

    public Policy matchSchema(Permission permission, int oid) {
        Policy result = Policy.REVOKE;
        for (Privilege privilege : this.privileges) {
            Subject ident = privilege.subject();
            if (ident.permission() != permission) continue;
            if (ident.securable() == Securable.SCHEMA && OidHash.schemaOid(ident.ident()) == oid) {
                return privilege.policy();
            }
            if (ident.securable() != Securable.CLUSTER) continue;
            result = privilege.policy();
        }
        return result;
    }

    public Set<String> grantedRoleNames() {
        HashSet<String> grantedRoleNames = HashSet.newHashSet(this.grantedRoles().size());
        for (GrantedRole grantedRole : this.grantedRoles) {
            grantedRoleNames.add(grantedRole.roleName());
        }
        return grantedRoleNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role that = (Role)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.privileges, that.privileges) && Objects.equals(this.grantedRoles, that.grantedRoles) && Objects.equals(this.isSuperUser, that.isSuperUser) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.privileges, this.grantedRoles, this.properties, this.isSuperUser);
    }

    public String toString() {
        return (this.isUser() ? "User{" : "Role{") + this.name + ", " + (this.password() == null ? "null" : "*****") + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.privileges.size());
        for (Privilege privilege : this.privileges) {
            privilege.writeTo(out);
        }
        out.writeCollection(this.grantedRoles);
        this.properties.writeTo(out);
    }

    public static Role fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("failed to parse a role, expecting the current token to be a field name, got " + String.valueOf(parser.currentToken()), new Object[0]);
        }
        String roleName = parser.currentName();
        Properties properties = null;
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        HashSet<GrantedRole> grantedRoles = new HashSet<GrantedRole>();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            block10: while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                switch (parser.currentName()) {
                    case "properties": {
                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("failed to parse a role, expected an start object token but got " + String.valueOf(parser.currentToken()), new Object[0]);
                        }
                        properties = Properties.fromXContent(parser);
                        if (parser.currentToken() == XContentParser.Token.END_OBJECT) continue block10;
                        throw new ElasticsearchParseException("failed to parse a role, expected an end object token but got " + String.valueOf(parser.currentToken()), new Object[0]);
                    }
                    case "privileges": {
                        if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                            throw new ElasticsearchParseException("failed to parse a role, expected an array token for privileges, got: " + String.valueOf(parser.currentToken()), new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            privileges.add(Privilege.fromXContent(parser));
                        }
                        continue block10;
                    }
                    case "granted_roles": {
                        if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                            throw new ElasticsearchParseException("failed to parse a role, expected an array token for granted_roles, got: " + String.valueOf(parser.currentToken()), new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            grantedRoles.add(GrantedRole.fromXContent(parser));
                        }
                        continue block10;
                    }
                }
                throw new ElasticsearchParseException("failed to parse a Role, unexpected field name: " + parser.currentName(), new Object[0]);
            }
            if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse a role, expected an object token at the end, got: " + String.valueOf(parser.currentToken()), new Object[0]);
            }
        }
        if (properties == null) {
            throw new ElasticsearchParseException("failed to parse role properties, not found", new Object[0]);
        }
        return new Role(roleName, new RolePrivileges(privileges), grantedRoles, properties, false);
    }

    public record Properties(boolean login, @Nullable SecureHash password, @Nullable JwtProperties jwtProperties, Map<String, Object> sessionSettings) implements Writeable
    {
        public static final String PASSWORD_KEY = "password";
        public static final String JWT_KEY = "jwt";

        public Properties(StreamInput in) throws IOException {
            this(in.readBoolean(), in.readOptionalWriteable(SecureHash::readFrom), in.getVersion().onOrAfter(Version.V_5_7_0) ? in.readOptionalWriteable(JwtProperties::readFrom) : null, in.getVersion().onOrAfter(Version.V_5_9_0) ? in.readMap() : Map.of());
        }

        public static Properties of(boolean login, boolean isReset, GenericProperties<Object> properties, SessionSettingRegistry sessionSettingRegistry) throws GeneralSecurityException {
            properties.ensureContainsOnly((Collection)Sets.concat(sessionSettingRegistry.settings().keySet(), (Object[])new String[]{PASSWORD_KEY, JWT_KEY}));
            SecureHash hash = null;
            String pw = DataTypes.STRING.implicitCast(properties.get(PASSWORD_KEY, null));
            if (pw != null) {
                try (SecureString secureString = new SecureString(pw.toCharArray());){
                    if (secureString.isEmpty()) {
                        throw new IllegalArgumentException("Password must not be empty");
                    }
                    hash = SecureHash.of(secureString);
                }
            }
            JwtProperties jwtProperties = JwtProperties.fromMap((Map)properties.getUnsafe(JWT_KEY));
            HashMap sessionSettings = new HashMap();
            for (Map.Entry p : properties) {
                String property = (String)p.getKey();
                if (property.equals(PASSWORD_KEY) || property.equals(JWT_KEY)) continue;
                Object value = p.getValue();
                if (!isReset) {
                    SessionSetting<?> sessionSetting = sessionSettingRegistry.settings().get(property);
                    assert (sessionSetting != null) : "sessionSetting shouldn't be null";
                    sessionSetting.validate(value);
                }
                sessionSettings.put(property, value);
            }
            return new Properties(login, hash, jwtProperties, Collections.unmodifiableMap(sessionSettings));
        }

        public static Properties fromXContent(XContentParser parser) throws IOException {
            boolean login = false;
            SecureHash secureHash = null;
            JwtProperties jwtProperties = null;
            Map<String, Object> sessionSettings = new HashMap<String, Object>();
            block12: while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                switch (parser.currentName()) {
                    case "login": {
                        parser.nextToken();
                        login = parser.booleanValue();
                        continue block12;
                    }
                    case "secure_hash": {
                        secureHash = SecureHash.fromXContent(parser);
                        continue block12;
                    }
                    case "jwt": {
                        jwtProperties = JwtProperties.fromXContent(parser);
                        continue block12;
                    }
                    case "session_settings": {
                        parser.nextToken();
                        sessionSettings = parser.map();
                        continue block12;
                    }
                }
                throw new ElasticsearchParseException("failed to parse role properties, unexpected field name: " + parser.currentName(), new Object[0]);
            }
            return new Properties(login, secureHash, jwtProperties, sessionSettings);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.login);
            out.writeOptionalWriteable(this.password);
            if (out.getVersion().onOrAfter(Version.V_5_7_0)) {
                out.writeOptionalWriteable(this.jwtProperties);
            }
            if (out.getVersion().onOrAfter(Version.V_5_9_0)) {
                out.writeMap(this.sessionSettings);
            }
        }
    }
}

