/*
 * Decompiled with CFR 0.152.
 */
package io.crate.server.xcontent;

import java.util.Locale;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;

public final class XContentParserUtils {
    private XContentParserUtils() {
    }

    public static void throwUnknownField(String field, XContentLocation location) {
        String message = "Failed to parse object: unknown field [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, field), new Object[0]);
    }

    public static void throwUnknownToken(XContentParser.Token token, XContentLocation location) {
        String message = "Failed to parse object: unexpected token [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, token), new Object[0]);
    }

    public static void ensureExpectedToken(XContentParser.Token expected, XContentParser.Token actual, XContentParser parser) {
        if (actual != expected) {
            throw XContentParserUtils.parsingException(parser, expected, actual);
        }
    }

    private static ParsingException parsingException(XContentParser parser, XContentParser.Token expected, XContentParser.Token actual) {
        return new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] but found [%s]", expected, actual), new Object[0]);
    }
}

