/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.statistics.SketchStreamer;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUnion;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class HistogramSketch<T> {
    private final ItemsSketch<T> sketch;
    private final SketchStreamer<T> streamer;

    public HistogramSketch(Class<T> clazz, DataType<T> dataType) {
        this.sketch = ItemsSketch.getInstance(clazz, dataType);
        this.streamer = new SketchStreamer<T>(dataType.streamer());
    }

    public HistogramSketch(Class<T> clazz, DataType<T> dataType, StreamInput in) throws IOException {
        byte[] bytes = in.readByteArray();
        this.streamer = new SketchStreamer<T>(dataType.streamer());
        this.sketch = ItemsSketch.getInstance(clazz, (Memory)Memory.wrap((byte[])bytes), dataType, this.streamer);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.sketch.toByteArray(this.streamer));
    }

    private HistogramSketch(SketchStreamer<T> streamer, ItemsSketch<T> sketch) {
        this.streamer = streamer;
        this.sketch = sketch;
    }

    public void update(T value) {
        this.sketch.update(value);
    }

    public HistogramSketch<T> merge(HistogramSketch<?> other) {
        ItemsUnion union = ItemsUnion.getInstance(this.sketch);
        union.union(other.sketch);
        return new HistogramSketch<T>(this.streamer, union.getResult());
    }

    public List<T> toHistogram(int maxBins, List<T> valuesToExclude) {
        if (this.sketch.isEmpty()) {
            return List.of();
        }
        HashSet<T> exclusions = new HashSet<T>(valuesToExclude);
        ArrayList<Object> histogram = new ArrayList<Object>();
        long count = this.sketch.getN();
        int numBins = (int)Math.min((long)maxBins, count);
        if (numBins <= 1) {
            return List.of();
        }
        long inc = (count - 1L) / (long)(numBins - 1);
        for (long rank = 0L; rank < count; rank += inc) {
            Object value = this.sketch.getQuantile((double)rank / (double)count, QuantileSearchCriteria.EXCLUSIVE);
            if (exclusions.contains(value)) continue;
            histogram.add(value);
        }
        return histogram;
    }
}

