/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.LongCursor;
import io.crate.common.collections.Lists;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.engine.fetch.FetchId;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.metadata.DocReferences;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.statistics.ColumnSketchBuilder;
import io.crate.statistics.Reservoir;
import io.crate.statistics.Samples;
import io.crate.statistics.SketchRamAccounting;
import io.crate.statistics.TableStatsService;
import io.crate.types.DataType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.jetbrains.annotations.VisibleForTesting;

public final class ReservoirSampler {
    private static final Logger LOGGER = LogManager.getLogger(ReservoirSampler.class);
    private final ClusterService clusterService;
    private final CircuitBreakerService circuitBreakerService;
    private final Schemas schemas;
    private final IndicesService indicesService;
    private final RateLimiter rateLimiter;

    @Inject
    public ReservoirSampler(ClusterService clusterService, CircuitBreakerService circuitBreakerService, NodeContext nodeContext, IndicesService indicesService, Settings settings) {
        this(clusterService, circuitBreakerService, nodeContext, indicesService, (RateLimiter)new RateLimiter.SimpleRateLimiter(TableStatsService.STATS_SERVICE_THROTTLING_SETTING.get(settings).getMbFrac()));
    }

    @VisibleForTesting
    ReservoirSampler(ClusterService clusterService, CircuitBreakerService circuitBreakerService, NodeContext nodeContext, IndicesService indicesService, RateLimiter rateLimiter) {
        this.clusterService = clusterService;
        this.circuitBreakerService = circuitBreakerService;
        this.schemas = nodeContext.schemas();
        this.indicesService = indicesService;
        this.rateLimiter = rateLimiter;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TableStatsService.STATS_SERVICE_THROTTLING_SETTING, this::updateReadLimit);
    }

    private void updateReadLimit(ByteSizeValue newReadLimit) {
        this.rateLimiter.setMBPerSec(newReadLimit.getMbFrac());
    }

    Samples getSamples(RelationName relationName, List<Reference> columns) {
        Samples samples;
        Object table;
        try {
            table = this.schemas.getTableInfo(relationName);
        }
        catch (RelationUnknown e) {
            return Samples.EMPTY;
        }
        if (!(table instanceof DocTableInfo)) {
            return Samples.EMPTY;
        }
        DocTableInfo docTable = (DocTableInfo)table;
        Random random = Randomness.get();
        Metadata metadata = this.clusterService.state().metadata();
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("query");
        BlockBasedRamAccounting ramAccounting = new BlockBasedRamAccounting(b -> breaker.addEstimateBytesAndMaybeBreak(b, "Reservoir-sampling"), 0x200000);
        SketchRamAccounting rla = new SketchRamAccounting((RamAccounting)ramAccounting, this.rateLimiter);
        try {
            samples = this.getSamples(columns, docTable, rla, random, metadata);
        }
        catch (Throwable throwable) {
            try {
                try {
                    rla.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        rla.close();
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Samples getSamples(List<Reference> columns, DocTableInfo docTable, SketchRamAccounting ramAccounting, Random random, Metadata metadata) throws IOException {
        Samples samples;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start collecting samples for table: {}({}),", (Object)docTable.ident().fqn(), (Object)columns.stream().map(r -> r.column().fqn()).collect(Collectors.joining(", ")));
        }
        Reservoir fetchIdSamples = new Reservoir(random);
        long totalNumDocs = 0L;
        long totalSizeInBytes = 0L;
        ArrayList columnCollectors = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            columnCollectors.add(new ColumnCollector(ramAccounting, columns.get(i).valueType()));
        }
        ArrayList<ShardExpressions> searchersToRelease = new ArrayList<ShardExpressions>();
        try {
            for (String string : docTable.concreteOpenIndices(metadata)) {
                IndexService indexService;
                IndexMetadata indexMetadata = metadata.index(string);
                if (indexMetadata == null || (indexService = this.indicesService.indexService(indexMetadata.getIndex())) == null) continue;
                String indexName = indexService.index().getName();
                for (IndexShard indexShard : indexService) {
                    ShardRouting routingEntry = indexShard.routingEntry();
                    if (!routingEntry.primary() || !routingEntry.active()) continue;
                    try {
                        Engine.Searcher searcher = indexShard.acquireSearcher("update-table-statistics");
                        List<? extends LuceneCollectorExpression<?>> expressions = ReservoirSampler.getCollectorExpressions(indexName, docTable, indexShard.getVersionCreated(), columns);
                        searchersToRelease.add(new ShardExpressions(indexShard, indexName, searcher, docTable, expressions));
                        totalNumDocs += (long)searcher.getIndexReader().numDocs();
                        totalSizeInBytes += indexShard.storeStats().getSizeInBytes();
                        ReservoirSampler.sampleDocIds(fetchIdSamples, searchersToRelease.size() - 1, searcher);
                    }
                    catch (AlreadyClosedException | IllegalIndexShardStateException throwable) {}
                }
            }
            ColumnSampler sampler = new ColumnSampler(columnCollectors, searchersToRelease::get);
            sampler.iterate(fetchIdSamples.samples());
            ArrayList statsBuilders = new ArrayList();
            for (ColumnCollector columnCollector : columnCollectors) {
                statsBuilders.add(columnCollector.statsBuilder);
            }
            samples = new Samples(statsBuilders, totalNumDocs, totalSizeInBytes);
        }
        catch (Throwable throwable) {
            for (ShardExpressions shard : searchersToRelease) {
                shard.searcher.close();
            }
            throw throwable;
        }
        for (ShardExpressions shard : searchersToRelease) {
            shard.searcher.close();
        }
        return samples;
    }

    @VisibleForTesting
    static void sampleDocIds(Reservoir reservoir, int readerIdx, IndexSearcher searcher) {
        try {
            searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new ReservoirCollectorManager(reservoir, readerIdx));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<? extends LuceneCollectorExpression<?>> getCollectorExpressions(String indexName, DocTableInfo docTable, Version shardCreatedVersion, List<Reference> columns) {
        LuceneReferenceResolver referenceResolver = new LuceneReferenceResolver(indexName, docTable.partitionedByColumns(), docTable.primaryKey(), shardCreatedVersion, docTable.isParentReferenceIgnored());
        return Lists.map(columns, x -> referenceResolver.getImplementation(DocReferences.toDocLookup(x)));
    }

    private static class ColumnCollector<T> {
        LuceneCollectorExpression<?> expression;
        final ColumnSketchBuilder<T> statsBuilder;
        final SketchRamAccounting ramAccounting;
        final DataType<T> dataType;

        private ColumnCollector(SketchRamAccounting ramAccounting, DataType<T> dataType) {
            this.statsBuilder = dataType.columnStatsSupport().sketchBuilder();
            this.dataType = dataType;
            this.ramAccounting = ramAccounting;
        }

        void setShard(LuceneCollectorExpression<?> collector) {
            this.expression = collector;
        }

        void collect(int docId) {
            this.expression.setNextDocId(docId);
            T value = this.dataType.sanitizeValue(this.expression.value());
            this.ramAccounting.addBytes(this.dataType.valueBytes(value));
            this.statsBuilder.add(value);
        }
    }

    private record ShardExpressions(IndexShard indexShard, String indexName, Engine.Searcher searcher, DocTableInfo tableInfo, List<? extends LuceneCollectorExpression<?>> expressions) {
        void updateColumnCollectors(List<ColumnCollector<?>> collectors) {
            assert (collectors.size() == this.expressions.size());
            CollectorContext context = new CollectorContext(() -> StoredRowLookup.create(this.indexShard.getVersionCreated(), this.tableInfo, this.indexName));
            for (int i = 0; i < collectors.size(); ++i) {
                LuceneCollectorExpression<?> expression = this.expressions.get(i);
                expression.startCollect(context);
                collectors.get(i).setShard(expression);
            }
        }
    }

    private static class ColumnSampler {
        final List<ColumnCollector<?>> collectors;
        final IntFunction<ShardExpressions> shardSupplier;
        ShardExpressions currentShard;
        ReaderContext currentLeafContext;
        int rowsCollected;
        long idCount;

        private ColumnSampler(List<ColumnCollector<?>> collectors, IntFunction<ShardExpressions> shardSupplier) {
            this.collectors = collectors;
            this.shardSupplier = shardSupplier;
        }

        public final void iterate(LongArrayList ids) throws IOException {
            this.idCount = ids.size();
            int currentShardId = -1;
            IndexReaderContext currentShardContext = null;
            int currentReaderCeiling = -1;
            int currentReaderDocBase = -1;
            for (LongCursor cursor : ids) {
                int docId;
                int shardId = FetchId.decodeReaderId(cursor.value);
                if (shardId != currentShardId) {
                    currentShardId = shardId;
                    currentShardContext = this.nextShard(shardId);
                    currentReaderCeiling = -1;
                }
                if ((docId = FetchId.decodeDocId(cursor.value)) >= currentReaderCeiling) {
                    assert (currentShardContext != null);
                    int contextOrd = ReaderUtil.subIndex((int)docId, (List)currentShardContext.leaves());
                    LeafReaderContext leafContext = this.nextReaderContext(contextOrd);
                    currentReaderDocBase = leafContext.docBase;
                    currentReaderCeiling = currentReaderDocBase + leafContext.reader().maxDoc();
                }
                if (this.collect(docId - currentReaderDocBase)) continue;
                break;
            }
        }

        protected IndexReaderContext nextShard(int shardId) {
            this.currentShard = this.shardSupplier.apply(shardId);
            this.currentShard.updateColumnCollectors(this.collectors);
            return this.currentShard.searcher.getTopReaderContext();
        }

        protected LeafReaderContext nextReaderContext(int contextOrd) throws IOException {
            LeafReaderContext ctx = (LeafReaderContext)this.currentShard.searcher.getLeafContexts().get(contextOrd);
            this.currentLeafContext = new ReaderContext(ctx);
            for (ColumnCollector<?> collector : this.collectors) {
                collector.expression.setNextReader(this.currentLeafContext);
            }
            return ctx;
        }

        protected boolean collect(int doc) {
            try {
                for (ColumnCollector<?> collector : this.collectors) {
                    collector.collect(doc);
                }
                ++this.rowsCollected;
                return true;
            }
            catch (CircuitBreakingException e) {
                LOGGER.info("Stopped gathering samples for `ANALYZE` operation because circuit breaker triggered. Generating statistics with {} instead of {} records", (Object)this.rowsCollected, (Object)this.idCount);
                return false;
            }
        }
    }

    private record ReservoirCollectorManager(Reservoir reservoir, int readerIdx) implements CollectorManager<Collector, Reservoir>
    {
        public Collector newCollector() throws IOException {
            return new Collector(){

                public LeafCollector getLeafCollector(LeafReaderContext context) {
                    return doc -> {
                        boolean shouldContinue = reservoir.update(FetchId.encode(readerIdx, doc + context.docBase));
                        if (!shouldContinue) {
                            throw new CollectionTerminatedException();
                        }
                    };
                }

                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE_NO_SCORES;
                }
            };
        }

        public Reservoir reduce(Collection<Collector> collectors) {
            return this.reservoir;
        }
    }
}

