/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.IntIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.IntEqQuery;
import io.crate.types.Regclass;
import io.crate.types.Regproc;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IntegerType
extends DataType<Integer>
implements Streamer<Integer>,
FixedWidthType {
    public static final IntegerType INSTANCE = new IntegerType();
    public static final int ID = 9;
    public static final int PRECISION = 32;
    public static final int INTEGER_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Integer.class);
    private static final StorageSupport<Number> STORAGE = new StorageSupport<Number>(true, true, (EqQuery)new IntEqQuery()){

        @Override
        public ValueIndexer<Number> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new IntIndexer(ref);
        }

        @Override
        public Integer decode(int input) {
            return input;
        }
    };

    private IntegerType() {
    }

    @Override
    public int id() {
        return 9;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.INTEGER;
    }

    @Override
    public String getName() {
        return "integer";
    }

    @Override
    public Integer numericPrecision() {
        return 32;
    }

    @Override
    public Streamer<Integer> streamer() {
        return this;
    }

    @Override
    public Integer implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Integer.parseInt(str);
        }
        if (value instanceof Regproc) {
            Regproc regproc = (Regproc)value;
            return regproc.oid();
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            BigInteger max = BigDecimal.valueOf(Integer.MAX_VALUE).toBigInteger();
            BigInteger min = BigDecimal.valueOf(Integer.MIN_VALUE).toBigInteger();
            if (max.compareTo(bigDecimalValue.toBigInteger()) <= 0 || min.compareTo(bigDecimalValue.toBigInteger()) >= 0) {
                throw new IllegalArgumentException(this.getName() + " value out of range: " + String.valueOf(value));
            }
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            long longVal = number.longValue();
            if (longVal < Integer.MIN_VALUE || Integer.MAX_VALUE < longVal) {
                throw new IllegalArgumentException("integer value out of range: " + longVal);
            }
            return ((Number)value).intValue();
        }
        if (value instanceof Regclass) {
            Regclass regclass = (Regclass)value;
            return regclass.oid();
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Integer sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i;
        }
        return ((Number)value).intValue();
    }

    @Override
    public int compare(Integer val1, Integer val2) {
        return Integer.compare(val1, val2);
    }

    @Override
    public Integer readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Integer.valueOf(in.readInt());
    }

    @Override
    public void writeValueTo(StreamOutput out, Integer v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeInt(v);
        }
    }

    @Override
    public int fixedSize() {
        return INTEGER_SIZE;
    }

    @Override
    public StorageSupport<Number> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Integer> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Integer.class, this);
    }

    @Override
    public long valueBytes(Integer value) {
        return INTEGER_SIZE;
    }
}

