/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Map;
import java.util.Objects;

public final class MapComparator {
    private MapComparator() {
    }

    public static <K, V> int compareMaps(Map<K, V> m1, Map<K, V> m2) {
        Objects.requireNonNull(m1, "map is null");
        Objects.requireNonNull(m2, "map is null");
        int sizeCompare = Integer.compare(m1.size(), m2.size());
        if (sizeCompare != 0) {
            return sizeCompare;
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            V thisValue = entry.getValue();
            V otherValue = m2.get(entry.getKey());
            if (thisValue == null) {
                if (otherValue == null) continue;
                return 1;
            }
            if (thisValue.equals(otherValue)) continue;
            if (otherValue == null) {
                return -1;
            }
            DataType<?> leftType = DataTypes.guessType(thisValue);
            int cmp = !thisValue.getClass().equals(otherValue.getClass()) ? leftType.compare(thisValue, leftType.implicitCast(otherValue)) : (leftType == DataTypes.UNTYPED_OBJECT ? MapComparator.compareMaps((Map)thisValue, (Map)otherValue) : leftType.compare(thisValue, otherValue));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

