/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.common.collections.Lists;
import io.crate.types.EqQuery;
import io.crate.types.NumericType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.jetbrains.annotations.Nullable;

public class NumericEqQuery {
    static EqQuery<BigDecimal> of(NumericType type) {
        Integer precision = type.numericPrecision();
        if (precision == null) {
            return new Unoptimized();
        }
        if (precision <= 18) {
            return new Compact(type);
        }
        return new Large(type);
    }

    private static List<BigDecimal> filterOutOfBoundsAndSetScale(List<BigDecimal> values, int scale) {
        return values.stream().map(val -> {
            BigDecimal scaledDown = val.setScale(scale, RoundingMode.DOWN);
            return scaledDown.compareTo((BigDecimal)val) == 0 ? scaledDown : null;
        }).filter(Objects::nonNull).toList();
    }

    static class Unoptimized
    implements EqQuery<BigDecimal> {
        Unoptimized() {
        }

        @Override
        @Nullable
        public Query termQuery(String field, BigDecimal value, boolean hasDocValues, boolean isIndexed) {
            return null;
        }

        @Override
        @Nullable
        public Query rangeQuery(String field, BigDecimal lowerTerm, BigDecimal upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            return null;
        }

        @Override
        @Nullable
        public Query termsQuery(String field, List<BigDecimal> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            return null;
        }
    }

    static class Compact
    implements EqQuery<BigDecimal> {
        private final NumericType type;

        private Compact(NumericType type) {
            this.type = type;
        }

        @Override
        @Nullable
        public Query termQuery(String field, BigDecimal value, boolean hasDocValues, boolean isIndexed) {
            BigDecimal scaleMatched = value.setScale((int)Objects.requireNonNull(this.type.scale()), RoundingMode.DOWN);
            if (scaleMatched.compareTo(value) != 0) {
                return new MatchNoDocsQuery("The given value holds extra non-zero scales");
            }
            if (isIndexed) {
                long longValue = scaleMatched.unscaledValue().longValueExact();
                return LongPoint.newExactQuery((String)field, (long)longValue);
            }
            if (hasDocValues) {
                long longValue = scaleMatched.unscaledValue().longValueExact();
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)longValue);
            }
            return null;
        }

        @Override
        @Nullable
        public Query rangeQuery(String field, BigDecimal lowerTerm, BigDecimal upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            long upper;
            long lower;
            if (lowerTerm == null) {
                lower = -999999999999999999L;
            } else {
                lowerTerm = lowerTerm.setScale((int)Objects.requireNonNull(this.type.scale()), includeLower ? RoundingMode.CEILING : RoundingMode.FLOOR);
                lower = lowerTerm.unscaledValue().longValueExact() + (long)(includeLower ? 0 : 1);
            }
            if (upperTerm == null) {
                upper = 999999999999999999L;
            } else {
                upperTerm = upperTerm.setScale((int)Objects.requireNonNull(this.type.scale()), includeUpper ? RoundingMode.FLOOR : RoundingMode.CEILING);
                upper = upperTerm.unscaledValue().longValueExact() + (long)(includeUpper ? 0 : -1);
            }
            return LongPoint.newRangeQuery((String)field, (long)lower, (long)upper);
        }

        @Override
        @Nullable
        public Query termsQuery(String field, List<BigDecimal> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            List<BigDecimal> scaleMatched = NumericEqQuery.filterOutOfBoundsAndSetScale(nonNullValues, Objects.requireNonNull(this.type.scale()));
            if (scaleMatched.isEmpty()) {
                return new MatchNoDocsQuery("The given values are out of bounds");
            }
            if (isIndexed) {
                return LongPoint.newSetQuery((String)field, (Collection)Lists.mapLazy(scaleMatched, x -> x.unscaledValue().longValueExact()));
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])scaleMatched.stream().mapToLong(x -> x.unscaledValue().longValueExact()).toArray());
            }
            return null;
        }
    }

    static class Large
    implements EqQuery<BigDecimal> {
        private final NumericType type;

        private Large(NumericType type) {
            this.type = type;
        }

        @Override
        @Nullable
        public Query termQuery(String field, BigDecimal value, boolean hasDocValues, boolean isIndexed) {
            BigDecimal scaleMatched = value.setScale((int)Objects.requireNonNull(this.type.scale()), RoundingMode.DOWN);
            if (scaleMatched.compareTo(value) != 0) {
                return new MatchNoDocsQuery("The given value holds extra non-zero scales");
            }
            return this.rangeQuery(field, scaleMatched, scaleMatched, true, true, hasDocValues, isIndexed);
        }

        @Override
        @Nullable
        public Query rangeQuery(String field, BigDecimal lowerTerm, BigDecimal upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                BigInteger upperInt;
                BigInteger lowerInt;
                final int maxBytes = this.type.maxBytes();
                byte[] lower = new byte[maxBytes];
                byte[] upper = new byte[maxBytes];
                if (lowerTerm == null) {
                    lowerInt = this.type.minValue();
                } else {
                    lowerTerm = lowerTerm.setScale((int)Objects.requireNonNull(this.type.scale()), includeLower ? RoundingMode.CEILING : RoundingMode.FLOOR);
                    lowerInt = lowerTerm.unscaledValue().add(includeLower ? BigInteger.ZERO : BigInteger.ONE);
                }
                if (upperTerm == null) {
                    upperInt = this.type.maxValue();
                } else {
                    upperTerm = upperTerm.setScale((int)Objects.requireNonNull(this.type.scale()), includeUpper ? RoundingMode.FLOOR : RoundingMode.CEILING);
                    upperInt = upperTerm.unscaledValue().subtract(includeUpper ? BigInteger.ZERO : BigInteger.ONE);
                }
                NumericUtils.bigIntToSortableBytes((BigInteger)lowerInt, (int)maxBytes, (byte[])lower, (int)0);
                NumericUtils.bigIntToSortableBytes((BigInteger)upperInt, (int)maxBytes, (byte[])upper, (int)0);
                return new PointRangeQuery(this, field, lower, upper, 1){

                    protected String toString(int dimension, byte[] value) {
                        return NumericUtils.sortableBytesToBigInt((byte[])value, (int)0, (int)maxBytes).toString();
                    }
                };
            }
            return null;
        }

        @Override
        @Nullable
        public Query termsQuery(String field, List<BigDecimal> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            final List<BigDecimal> scaleMatched = NumericEqQuery.filterOutOfBoundsAndSetScale(nonNullValues, Objects.requireNonNull(this.type.scale()));
            if (scaleMatched.isEmpty()) {
                return new MatchNoDocsQuery("The given values are out of bounds");
            }
            if (isIndexed) {
                final int maxBytes = this.type.maxBytes();
                final BytesRef encoded = new BytesRef(new byte[maxBytes]);
                return new PointInSetQuery(this, field, 1, maxBytes, new PointInSetQuery.Stream(this){
                    int idx = 0;

                    public BytesRef next() {
                        if (this.idx == scaleMatched.size()) {
                            return null;
                        }
                        BigDecimal bigDecimal = (BigDecimal)scaleMatched.get(this.idx);
                        ++this.idx;
                        NumericUtils.bigIntToSortableBytes((BigInteger)bigDecimal.unscaledValue(), (int)maxBytes, (byte[])encoded.bytes, (int)0);
                        return encoded;
                    }
                }){

                    protected String toString(byte[] value) {
                        return NumericUtils.sortableBytesToBigInt((byte[])value, (int)0, (int)maxBytes).toString();
                    }
                };
            }
            return null;
        }
    }
}

