/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.IntegerType;
import java.util.List;
import org.apache.lucene.util.RamUsageEstimator;

public class OidVectorType
extends DataType<List<Integer>> {
    public static final String NAME = "oidvector";
    public static final int ID = 21;

    @Override
    public int compare(List<Integer> o1, List<Integer> o2) {
        return DataTypes.INTEGER_ARRAY.compare(o1, o2);
    }

    @Override
    public int id() {
        return 21;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.ARRAY;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<List<Integer>> streamer() {
        return DataTypes.INTEGER_ARRAY.streamer();
    }

    @Override
    public List<Integer> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return (List)value;
    }

    @Override
    public List<Integer> sanitizeValue(Object value) {
        return (List)value;
    }

    @Override
    public long valueBytes(List<Integer> value) {
        if (value == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        return (long)value.size() * (long)IntegerType.INTEGER_SIZE;
    }
}

