/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.TypeSignature;
import io.crate.types.TypeSignatureType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class ParameterTypeSignature
extends TypeSignature {
    private final String parameterName;

    public ParameterTypeSignature(String parameterName, TypeSignature typeSignature) {
        super(typeSignature.getBaseTypeName(), typeSignature.getParameters());
        this.parameterName = ParameterTypeSignature.unEscape(parameterName);
    }

    public ParameterTypeSignature(StreamInput in) throws IOException {
        super(in);
        this.parameterName = in.readString();
    }

    public String escapedParameterName() {
        return ParameterTypeSignature.escape(this.parameterName);
    }

    public String unescapedParameterName() {
        return this.parameterName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.parameterName);
    }

    @Override
    public TypeSignatureType type() {
        return TypeSignatureType.PARAMETER_TYPE_SIGNATURE;
    }

    @Override
    public String toString() {
        return "\"" + this.escapedParameterName() + "\" " + super.toString();
    }

    private static String escape(String input) {
        return input.replace("\"", "\\\"");
    }

    private static String unEscape(String input) {
        return input.replace("\\\"", "\"");
    }
}

