/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.IntIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.IntEqQuery;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShortType
extends DataType<Short>
implements Streamer<Short>,
FixedWidthType {
    public static final ShortType INSTANCE = new ShortType();
    public static final int ID = 8;
    public static final int PRECISION = 16;
    private static final int SHORT_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Short.class);
    private static final StorageSupport<Number> STORAGE = new StorageSupport<Number>(true, true, (EqQuery)new IntEqQuery()){

        @Override
        public ValueIndexer<Number> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new IntIndexer(ref);
        }

        @Override
        public Short decode(int input) {
            return (short)input;
        }
    };

    private ShortType() {
    }

    @Override
    public int id() {
        return 8;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.SHORT;
    }

    @Override
    public Integer numericPrecision() {
        return 16;
    }

    @Override
    public String getName() {
        return "smallint";
    }

    @Override
    public Streamer<Short> streamer() {
        return this;
    }

    @Override
    public Short implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Short.valueOf(str);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            try {
                return bigDecimal.shortValueExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("short value out of range: " + String.valueOf(value));
            }
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            int intVal = number.intValue();
            if (intVal < Short.MIN_VALUE || Short.MAX_VALUE < intVal) {
                throw new IllegalArgumentException("short value out of range: " + intVal);
            }
            return ((Number)value).shortValue();
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Short sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s;
        }
        return ((Number)value).shortValue();
    }

    @Override
    public int compare(Short val1, Short val2) {
        return Short.compare(val1, val2);
    }

    @Override
    public Short readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Short.valueOf(in.readShort());
    }

    @Override
    public void writeValueTo(StreamOutput out, Short v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeShort(v);
        }
    }

    @Override
    public int fixedSize() {
        return SHORT_SIZE;
    }

    @Override
    public StorageSupport<Number> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Short> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Short.class, this);
    }

    @Override
    public long valueBytes(Short value) {
        return SHORT_SIZE;
    }
}

