/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UndefinedType;
import org.jetbrains.annotations.Nullable;

public final class TypeCompatibility {
    @Nullable
    public static DataType<?> getCommonType(DataType<?> type1, DataType<?> type2) {
        if (type1.equals(type2)) {
            return type2;
        }
        if (type1.equals(UndefinedType.INSTANCE)) {
            return type2;
        }
        if (type2.equals(UndefinedType.INSTANCE)) {
            return type1;
        }
        if (!type1.getTypeParameters().isEmpty() || !type2.getTypeParameters().isEmpty()) {
            try {
                return DataTypes.merge(type1, type2);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return TypeCompatibility.convertTypeByPrecedence(type1, type2);
    }

    @Nullable
    private static DataType<?> convertTypeByPrecedence(DataType<?> type1, DataType<?> type2) {
        DataType<?> lowerPrecedenceArg;
        DataType<?> higherPrecedenceArg;
        if (type1.precedes(type2)) {
            higherPrecedenceArg = type1;
            lowerPrecedenceArg = type2;
        } else {
            higherPrecedenceArg = type2;
            lowerPrecedenceArg = type1;
        }
        if (lowerPrecedenceArg.isConvertableTo(higherPrecedenceArg, false)) {
            return higherPrecedenceArg;
        }
        if (higherPrecedenceArg.isConvertableTo(lowerPrecedenceArg, false)) {
            return lowerPrecedenceArg;
        }
        return null;
    }
}

