/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import io.crate.common.CheckedFunction;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedRunnable;

public interface ActionListener<Response>
extends BiConsumer<Response, Throwable> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    @Override
    default public void accept(Response response, Throwable throwable) {
        if (throwable == null) {
            this.onResponse(response);
        } else {
            this.onFailure(Exceptions.toException((Throwable)SQLExceptions.unwrap(throwable)));
        }
    }

    default public <T, E extends Exception> ActionListener<T> map(CheckedFunction<? super T, Response, E> fn) {
        return this.withOnResponse((l, response) -> l.onResponse(fn.apply(response)));
    }

    public static <Response> ActionListener<Response> wrap(CheckedConsumer<Response, ? extends Exception> onResponse, Consumer<Exception> onFailure) {
        return new SimpleListener<Response>(onResponse, onFailure);
    }

    default public <T> ActionListener<T> withOnResponse(CheckedBiConsumer<ActionListener<Response>, T, Exception> onResponse) {
        ActionListener original = this;
        return new SimpleListener<Object>(response -> onResponse.accept(original, response), original::onFailure);
    }

    default public ActionListener<Response> withOnFailure(CheckedBiConsumer<ActionListener<Response>, Exception, Exception> onFailure) {
        ActionListener original = this;
        return new SimpleListener<Object>(original::onResponse, ex -> {
            try {
                onFailure.accept(original, (Exception)ex);
            }
            catch (Exception onFailureEx) {
                original.onFailure(onFailureEx);
            }
        });
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return new SimpleListener<Object>(object -> runnable.run(), exception -> runnable.run());
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        SQLExceptions.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        SQLExceptions.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    default public ActionListener<Response> runAfter(Runnable runAfter) {
        ActionListener original = this;
        return new SimpleListener<Object>(response -> {
            try {
                original.onResponse(response);
            }
            finally {
                runAfter.run();
            }
        }, err -> {
            try {
                original.onFailure((Exception)err);
            }
            finally {
                runAfter.run();
            }
        });
    }

    default public ActionListener<Response> runBefore(CheckedRunnable<?> runBefore) {
        ActionListener original = this;
        return new SimpleListener<Object>(response -> {
            try {
                runBefore.run();
            }
            catch (Exception ex) {
                original.onFailure(ex);
                return;
            }
            original.onResponse(response);
        }, err -> {
            try {
                runBefore.run();
            }
            catch (Exception ex) {
                err.addSuppressed(ex);
            }
            original.onFailure((Exception)err);
        });
    }

    public static class SimpleListener<T>
    implements ActionListener<T> {
        private final CheckedConsumer<T, ? extends Exception> onResponse;
        private final Consumer<Exception> onFailure;

        private SimpleListener(CheckedConsumer<T, ? extends Exception> onResponse, Consumer<Exception> onFailure) {
            this.onResponse = onResponse;
            this.onFailure = onFailure;
        }

        @Override
        public void onResponse(T response) {
            try {
                this.onResponse.accept(response);
            }
            catch (Exception e) {
                this.onFailure.accept(e);
            }
            catch (Throwable t) {
                this.onFailure.accept(Exceptions.toException((Throwable)t));
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.onFailure.accept(e);
        }
    }
}

