/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.put;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutRepository
extends TransportMasterNodeAction<PutRepositoryRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportPutRepository(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, PutRepositoryRequest::new);
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(PutRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ((CompletableFuture)this.repositoriesService.registerRepository(request).thenApply(resp -> new AcknowledgedResponse(resp.isAcknowledged()))).whenComplete(listener);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "cluster:admin/repository/put";

        private Action() {
            super(NAME);
        }
    }
}

