/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateSnapshot
extends TransportMasterNodeAction<CreateSnapshotRequest, CreateSnapshotResponse> {
    public static final Action ACTION = new Action();
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportCreateSnapshot(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateSnapshotRequest::new);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected CreateSnapshotResponse read(StreamInput in) throws IOException {
        return new CreateSnapshotResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateSnapshotRequest request, ClusterState state) {
        ClusterBlockException clusterBlockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        if (clusterBlockException != null) {
            return clusterBlockException;
        }
        String[] indices = (String[])request.relationNames().stream().map(r -> state.metadata().getIndices((RelationName)r, List.of(), false, im -> im.getIndex().getName())).flatMap(Collection::stream).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, indices);
    }

    @Override
    protected void masterOperation(CreateSnapshotRequest request, ClusterState state, ActionListener<CreateSnapshotResponse> listener) {
        if (request.waitForCompletion()) {
            this.snapshotsService.executeSnapshot(request, listener.map(CreateSnapshotResponse::new));
        } else {
            this.snapshotsService.createSnapshot(request, listener.map(snapshot -> new CreateSnapshotResponse()));
        }
    }

    public static class Action
    extends ActionType<CreateSnapshotResponse> {
        private static final String NAME = "cluster:admin/snapshot/create";

        private Action() {
            super(NAME);
        }
    }
}

