/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportClusterState
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportClusterState(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, ACTION.name(), false, transportService, clusterService, threadPool, ClusterStateRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterStateResponse read(StreamInput in) throws IOException {
        return new ClusterStateResponse(in);
    }

    @Override
    protected void masterOperation(final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<ClusterState> acceptableClusterStateOrNotMasterPredicate;
        final Predicate<ClusterState> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? clusterState -> true : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<ClusterState> predicate = acceptableClusterStateOrNotMasterPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedMaster());
        if (acceptableClusterStatePredicate.test(state)) {
            try {
                listener.onResponse(TransportClusterState.buildResponse(request, state, this.logger));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        } else {
            assert (!acceptableClusterStateOrNotMasterPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService.getClusterApplierService(), request.waitForTimeout(), this.logger).waitForNextChange(new ClusterStateObserver.Listener(){
                final /* synthetic */ TransportClusterState this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (acceptableClusterStatePredicate.test(newState)) {
                        try {
                            listener.onResponse(TransportClusterState.buildResponse(request, newState, this.this$0.logger));
                        }
                        catch (Exception ex) {
                            listener.onFailure(ex);
                        }
                    } else {
                        listener.onFailure(new NotMasterException("master stepped down waiting for metadata version " + request.waitForMetadataVersion()));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    try {
                        listener.onResponse(new ClusterStateResponse(state.getClusterName(), null, true));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            }, acceptableClusterStateOrNotMasterPredicate);
        }
    }

    @VisibleForTesting
    static ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState currentState, Logger logger) {
        logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (!request.relationNames().isEmpty()) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                List indices = request.relationNames().stream().map(r -> currentState.metadata().getIndices((RelationName)r, List.of(), false, im -> im.getIndex().getName())).flatMap(Collection::stream).toList();
                for (String filteredIndex : indices) {
                    if (!currentState.routingTable().indicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().indicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        if (request.metadata()) {
            if (request.relationNames().isEmpty()) {
                mdBuilder = Metadata.builder(currentState.metadata());
            } else {
                for (RelationName relationName : request.relationNames()) {
                    Object relationMetadata = currentState.metadata().getRelation(relationName);
                    if (!(relationMetadata instanceof RelationMetadata.Table)) continue;
                    RelationMetadata.Table table = (RelationMetadata.Table)relationMetadata;
                    mdBuilder.setTable(relationName, table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), table.indexUUIDs(), table.tableVersion());
                    for (String indexUUID : table.indexUUIDs()) {
                        IndexMetadata indexMetadata = currentState.metadata().indexByUUID(indexUUID);
                        if (indexMetadata == null) continue;
                        mdBuilder.put(indexMetadata, false);
                    }
                }
            }
            for (ObjectObjectCursor objectObjectCursor : currentState.metadata().customs()) {
                if (((Metadata.Custom)objectObjectCursor.value).context().contains((Object)Metadata.XContentContext.API)) continue;
                mdBuilder.removeCustom((String)objectObjectCursor.key);
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (ObjectObjectCursor objectObjectCursor : currentState.customs()) {
                if (((ClusterState.Custom)objectObjectCursor.value).isPrivate()) continue;
                builder.putCustom((String)objectObjectCursor.key, (ClusterState.Custom)objectObjectCursor.value);
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }

    public static class Action
    extends ActionType<ClusterStateResponse> {
        private static final String NAME = "cluster:monitor/state";

        private Action() {
            super(NAME);
        }

        @Override
        public Writeable.Reader<ClusterStateResponse> getResponseReader() {
            return ClusterStateResponse::new;
        }
    }
}

