/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class Alias
implements Writeable {
    private static final ParseField FILTER = new ParseField("filter", new String[0]);
    private String name;

    public Alias(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Alias(StreamInput in) throws IOException {
        this.name = in.readString();
        if (in.getVersion().before(Version.V_5_3_0)) {
            in.readOptionalString();
            in.readOptionalString();
            in.readOptionalString();
            in.readOptionalBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().before(Version.V_5_3_0)) {
            out.writeOptionalString(null);
            out.writeOptionalString(null);
            out.writeOptionalString(null);
            out.writeOptionalBoolean(null);
        }
    }

    public static Alias fromXContent(XContentParser parser) throws IOException {
        Alias alias = new Alias(parser.currentName());
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            throw new IllegalArgumentException("No alias is specified");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT || !FILTER.match(currentFieldName, parser.getDeprecationHandler())) continue;
            parser.mapOrdered();
        }
        return alias;
    }

    public String toString() {
        return "Alias{name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return !(this.name != null ? !this.name.equals(alias.name) : alias.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

