/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndex
extends TransportMasterNodeAction<DeleteIndexRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final MetadataDeleteIndexService deleteIndexService;

    @Inject
    public TransportDeleteIndex(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DeleteIndexRequest::new);
        this.deleteIndexService = deleteIndexService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        String[] indices = (String[])state.metadata().getIndices(request.partitions(), false, im -> im.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesAllowReleaseResources(indices);
    }

    @Override
    protected void masterOperation(DeleteIndexRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        final List<Index> concreteIndices = state.metadata().getIndices(request.partitions(), false, IndexMetadata::getIndex);
        if (concreteIndices.isEmpty()) {
            listener.onResponse(new AcknowledgedResponse(true));
            return;
        }
        String source = "delete-index " + String.valueOf(request.partitions());
        AckedClusterStateUpdateTask<AcknowledgedResponse> updateTask = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, Priority.URGENT, (AckedRequest)request, listener){
            final /* synthetic */ TransportDeleteIndex this$0;
            {
                this.this$0 = this$0;
                super(priority, request, listener);
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return this.this$0.deleteIndexService.deleteIndices(currentState, concreteIndices);
            }
        };
        this.clusterService.submitStateUpdateTask(source, updateTask);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "indices:admin/delete";

        private Action() {
            super(NAME);
        }
    }
}

