/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest> {
    private final RelationName table;
    private final List<String> partitionValues;
    private final int newNumShards;

    public ResizeRequest(RelationName table, List<String> partitionValues, int newNumShards) {
        this.table = table;
        this.partitionValues = partitionValues;
        this.newNumShards = newNumShards;
        this.timeout = TimeValue.timeValueSeconds((long)(this.timeout.seconds() * 2L));
        this.masterNodeTimeout = TimeValue.timeValueSeconds((long)(this.masterNodeTimeout.seconds() * 2L));
    }

    public ResizeRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_5_10_0)) {
            this.table = new RelationName(in);
            int numValues = in.readVInt();
            this.partitionValues = new ArrayList<String>(numValues);
            for (int i = 0; i < numValues; ++i) {
                this.partitionValues.add(in.readOptionalString());
            }
        } else {
            throw new UnsupportedOperationException("Cannot stream ResizeRequest in mixed 6.0.0/<5.10 clusters. All nodes need to be >= 5.10");
        }
        this.newNumShards = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_10_0)) {
            this.table.writeTo(out);
            out.writeVInt(this.partitionValues.size());
            for (String value : this.partitionValues) {
                out.writeOptionalString(value);
            }
        } else {
            throw new UnsupportedOperationException("Cannot stream ResizeRequest in mixed 6.0.0/<5.10 clusters. All nodes need to be >= 5.10");
        }
        out.writeVInt(this.newNumShards);
    }

    public RelationName table() {
        return this.table;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public int newNumShards() {
        return this.newNumShards;
    }
}

