/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public final class ChannelActionListener<Response extends TransportResponse>
implements ActionListener<Response> {
    private static final Logger LOGGER = LogManager.getLogger(ChannelActionListener.class);
    private final TransportChannel channel;

    public ChannelActionListener(TransportChannel channel) {
        this.channel = channel;
    }

    @Override
    public void onResponse(Response response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (Exception e1) {
            e1.addSuppressed(e);
            LOGGER.warn("Failed to send error response on channel={} err={}", (Object)this.channel, (Object)e1);
        }
    }
}

