/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse, NodeRequest extends BaseNodeRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Class<NodeResponse> nodeResponseClass;
    final String transportNodeAction;

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, Writeable.Reader<NodesRequest> nodesRequestReader, Writeable.Reader<NodeRequest> nodeRequestReader, String nodeExecutor, Class<NodeResponse> nodeResponseClass) {
        super(actionName, transportService, nodesRequestReader);
        this.threadPool = threadPool;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.nodeResponseClass = Objects.requireNonNull(nodeResponseClass);
        this.transportNodeAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, nodeRequestReader, new NodeTransportHandler());
    }

    @Override
    protected void doExecute(NodesRequest request, ActionListener<NodesResponse> listener) {
        new AsyncAction(this, request, listener).start();
    }

    protected NodesResponse newResponse(NodesRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList<BaseNodeResponse> responses = new ArrayList<BaseNodeResponse>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object response = nodesResponses.get(i);
            if (response instanceof FailedNodeException) {
                failures.add((FailedNodeException)response);
                continue;
            }
            responses.add((BaseNodeResponse)this.nodeResponseClass.cast(response));
        }
        return this.newResponse(request, responses, failures);
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected abstract NodeRequest newNodeRequest(NodesRequest var1);

    protected abstract NodeResponse read(StreamInput var1) throws IOException;

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request));
        }
    }

    static class AsyncAction {
        private final NodesRequest request;
        private final ActionListener<NodesResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        final /* synthetic */ TransportNodesAction this$0;

        AsyncAction(NodesRequest request, ActionListener<NodesResponse> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            this.responses = new AtomicReferenceArray(((BaseNodesRequest)request).concreteNodes().length);
        }

        void start() {
            DiscoveryNode[] nodes = ((BaseNodesRequest)this.request).concreteNodes();
            if (nodes.length == 0) {
                this.this$0.threadPool.generic().execute(() -> this.listener.onResponse(this.this$0.newResponse(this.request, this.responses)));
                return;
            }
            TransportRequestOptions requestOptions = new TransportRequestOptions(((BaseNodesRequest)this.request).timeout());
            for (int i = 0; i < nodes.length; ++i) {
                final int idx = i;
                final DiscoveryNode node = nodes[i];
                String nodeId = node.getId();
                try {
                    Object nodeRequest = this.this$0.newNodeRequest(this.request);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, requestOptions, new TransportResponseHandler<NodeResponse>(){
                        final /* synthetic */ AsyncAction this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public NodeResponse read(StreamInput in) throws IOException {
                            return this.this$1.this$0.read(in);
                        }

                        @Override
                        public void handleResponse(NodeResponse response) {
                            this.this$1.onOperation(idx, response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            this.this$1.onFailure(idx, node.getId(), exp);
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    this.onFailure(idx, nodeId, e);
                }
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug((Message)new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            }
            this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Exception e) {
                this.this$0.logger.debug("failed to combine responses from nodes", (Throwable)e);
                this.listener.onFailure(e);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }
}

