/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import io.crate.exceptions.SQLExceptions;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public abstract class TransportSingleShardAction<Request extends SingleShardRequest, Response extends TransportResponse>
extends TransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    private final String transportShardAction;
    private final String executor;
    protected final Logger logger = LogManager.getLogger(this.getClass());

    protected TransportSingleShardAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, Writeable.Reader<Request> request, String executor) {
        super(actionName);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportShardAction = actionName + "[s]";
        this.executor = executor;
        if (!this.isSubAction()) {
            transportService.registerRequestHandler(actionName, "same", request, new TransportHandler());
        }
        transportService.registerRequestHandler(this.transportShardAction, "same", request, new ShardTransportHandler());
    }

    protected boolean isSubAction() {
        return false;
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract Response shardOperation(Request var1, ShardId var2) throws IOException;

    protected void asyncShardOperation(Request request, ShardId shardId, ActionListener<Response> listener) throws IOException {
        this.threadPool.executor(this.getExecutor(request, shardId)).execute(ActionRunnable.supply(listener, () -> this.shardOperation(request, shardId)));
    }

    protected abstract Writeable.Reader<Response> getResponseReader();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Nullable
    protected abstract ShardsIterator shards(ClusterState var1, Request var2);

    protected String getExecutor(Request request, ShardId shardId) {
        return this.executor;
    }

    private class TransportHandler
    implements TransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            TransportSingleShardAction.this.execute(request).whenComplete((BiConsumer)new ChannelActionListener(channel));
        }
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            if (TransportSingleShardAction.this.logger.isTraceEnabled()) {
                TransportSingleShardAction.this.logger.trace("executing [{}] on shard [{}]", request, (Object)((SingleShardRequest)request).internalShardId);
            }
            TransportSingleShardAction.this.asyncShardOperation(request, ((SingleShardRequest)request).internalShardId, new ChannelActionListener(channel));
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardIt;
        private final Request request;
        private final DiscoveryNodes nodes;
        private volatile Exception lastFailure;
        final /* synthetic */ TransportSingleShardAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = this$0.clusterService.state();
            if (this$0.logger.isTraceEnabled()) {
                this$0.logger.trace("executing [{}] based on cluster state version [{}]", request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = this$0.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            ClusterBlocks blocks = clusterState.blocks();
            blockException = blocks.indexBlockedException(ClusterBlockLevel.READ, ((SingleShardRequest)request).index());
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = this$0.shards(clusterState, request);
        }

        public void start() {
            if (this.shardIt == null) {
                Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(this.this$0.clusterService.localNode(), this.this$0.transportShardAction, (TransportRequest)this.request, new ActionListenerResponseHandler(this.this$0.transportShardAction, this.listener, reader));
            } else {
                this.perform(null);
            }
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, this.request), (Throwable)e);
            }
            this.perform(e);
        }

        private void perform(@Nullable Exception currentFailure) {
            ShardRouting shardRouting;
            Exception lastFailure = this.lastFailure;
            if (lastFailure == null || !SQLExceptions.isShardNotAvailable(currentFailure)) {
                lastFailure = currentFailure;
                this.lastFailure = currentFailure;
            }
            if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                Exception failure = lastFailure;
                if (failure == null || SQLExceptions.isShardNotAvailable(failure)) {
                    failure = new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.request), failure);
                } else {
                    this.this$0.logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", null, this.request), (Throwable)failure);
                }
                this.listener.onFailure(failure);
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                ((SingleShardRequest)this.request).internalShardId = shardRouting.shardId();
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("sending request [{}] to shard [{}] on node [{}]", this.request, (Object)((SingleShardRequest)this.request).internalShardId, (Object)node);
                }
                final Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)this.request, new TransportResponseHandler<Response>(){
                    final /* synthetic */ AsyncSingleAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Response read(StreamInput in) throws IOException {
                        return (TransportResponse)reader.read(in);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        this.this$1.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        this.this$1.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }
}

