/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealth;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStats;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.state.TransportClusterState;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.refresh.TransportRefresh;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettings;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStats;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public interface Client
extends Releasable {
    public <Req extends TransportRequest, Resp extends TransportResponse> CompletableFuture<Resp> execute(ActionType<Resp> var1, Req var2);

    default public CompletableFuture<ClusterHealthResponse> health(ClusterHealthRequest request) {
        return this.execute(TransportClusterHealth.ACTION, request);
    }

    default public CompletableFuture<ClusterStateResponse> state(ClusterStateRequest request) {
        return this.execute(TransportClusterState.ACTION, request);
    }

    default public CompletableFuture<NodesStatsResponse> nodesStats(NodesStatsRequest request) {
        return this.execute(TransportNodesStats.ACTION, request);
    }

    default public CompletableFuture<RefreshResponse> refresh(RefreshRequest request) {
        return this.execute(TransportRefresh.ACTION, request);
    }

    default public CompletableFuture<IndicesStatsResponse> stats(IndicesStatsRequest request) {
        return this.execute(TransportIndicesStats.ACTION, request);
    }

    default public CompletableFuture<AcknowledgedResponse> updateSettings(UpdateSettingsRequest request) {
        return this.execute(TransportUpdateSettings.ACTION, request);
    }
}

