/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.NodeHealthCheckFailureException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class FollowersChecker {
    private static final Logger LOGGER = LogManager.getLogger(FollowersChecker.class);
    public static final String FOLLOWER_CHECK_ACTION_NAME = "internal:coordination/fault_detection/follower_check";
    public static final Setting<TimeValue> FOLLOWER_CHECK_INTERVAL_SETTING = Setting.timeSetting("cluster.fault_detection.follower_check.interval", TimeValue.timeValueMillis((long)1000L), TimeValue.timeValueMillis((long)100L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> FOLLOWER_CHECK_TIMEOUT_SETTING = Setting.timeSetting("cluster.fault_detection.follower_check.timeout", TimeValue.timeValueMillis((long)10000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<Integer> FOLLOWER_CHECK_RETRY_COUNT_SETTING = Setting.intSetting("cluster.fault_detection.follower_check.retry_count", 3, 1, Setting.Property.NodeScope);
    private final TimeValue followerCheckInterval;
    private final TimeValue followerCheckTimeout;
    private final int followerCheckRetryCount;
    private final BiConsumer<DiscoveryNode, String> onNodeFailure;
    private final Consumer<FollowerCheckRequest> handleRequestAndUpdateState;
    private final Object mutex = new Object();
    private final Map<DiscoveryNode, FollowerChecker> followerCheckers = new ConcurrentHashMap<DiscoveryNode, FollowerChecker>();
    private final Set<DiscoveryNode> faultyNodes = new HashSet<DiscoveryNode>();
    private final TransportService transportService;
    private final NodeHealthService nodeHealthService;
    private volatile FastResponseState fastResponseState;

    public FollowersChecker(Settings settings, TransportService transportService, Consumer<FollowerCheckRequest> handleRequestAndUpdateState, BiConsumer<DiscoveryNode, String> onNodeFailure, NodeHealthService nodeHealthService) {
        this.transportService = transportService;
        this.handleRequestAndUpdateState = handleRequestAndUpdateState;
        this.onNodeFailure = onNodeFailure;
        this.nodeHealthService = nodeHealthService;
        this.followerCheckInterval = FOLLOWER_CHECK_INTERVAL_SETTING.get(settings);
        this.followerCheckTimeout = FOLLOWER_CHECK_TIMEOUT_SETTING.get(settings);
        this.followerCheckRetryCount = FOLLOWER_CHECK_RETRY_COUNT_SETTING.get(settings);
        this.updateFastResponseState(0L, Coordinator.Mode.CANDIDATE);
        transportService.registerRequestHandler(FOLLOWER_CHECK_ACTION_NAME, "same", false, false, FollowerCheckRequest::new, (request, transportChannel) -> this.handleFollowerCheck((FollowerCheckRequest)request, transportChannel));
        transportService.addConnectionListener(new TransportConnectionListener(){

            @Override
            public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
                FollowersChecker.this.handleDisconnectedNode(node);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentNodes(DiscoveryNodes discoveryNodes) {
        Object object = this.mutex;
        synchronized (object) {
            Predicate<DiscoveryNode> isUnknownNode = n -> !discoveryNodes.nodeExists((DiscoveryNode)n);
            this.followerCheckers.keySet().removeIf(isUnknownNode);
            this.faultyNodes.removeIf(isUnknownNode);
            discoveryNodes.mastersFirstStream().forEach(discoveryNode -> {
                if (!(discoveryNode.equals(discoveryNodes.getLocalNode()) || this.followerCheckers.containsKey(discoveryNode) || this.faultyNodes.contains(discoveryNode))) {
                    FollowerChecker followerChecker = new FollowerChecker((DiscoveryNode)discoveryNode);
                    this.followerCheckers.put((DiscoveryNode)discoveryNode, followerChecker);
                    followerChecker.start();
                }
            });
        }
    }

    public void clearCurrentNodes() {
        this.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
    }

    public void updateFastResponseState(long term, Coordinator.Mode mode) {
        this.fastResponseState = new FastResponseState(term, mode);
    }

    private void handleFollowerCheck(final FollowerCheckRequest request, final TransportChannel transportChannel) throws IOException {
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            String message = "handleFollowerCheck: node is unhealthy [" + statusInfo.getInfo() + "], rejecting " + statusInfo.getInfo();
            LOGGER.debug(message);
            throw new NodeHealthCheckFailureException(message, new Object[0]);
        }
        FastResponseState responder = this.fastResponseState;
        if (responder.mode == Coordinator.Mode.FOLLOWER && responder.term == request.term) {
            LOGGER.trace("responding to {} on fast path", (Object)request);
            transportChannel.sendResponse(TransportResponse.Empty.INSTANCE);
            return;
        }
        if (request.term < responder.term) {
            throw new CoordinationStateRejectedException("rejecting " + String.valueOf(request) + " since local state is " + String.valueOf(this), new Object[0]);
        }
        this.transportService.getThreadPool().generic().execute(new RejectableRunnable(){
            final /* synthetic */ FollowersChecker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void doRun() throws IOException {
                LOGGER.trace("responding to {} on slow path", (Object)request);
                try {
                    this.this$0.handleRequestAndUpdateState.accept(request);
                }
                catch (Exception e) {
                    transportChannel.sendResponse(e);
                    return;
                }
                transportChannel.sendResponse(TransportResponse.Empty.INSTANCE);
            }

            @Override
            public void onFailure(Exception e) {
                LOGGER.debug((Message)new ParameterizedMessage("exception while responding to {}", (Object)request), (Throwable)e);
            }

            public String toString() {
                return "slow path response to " + String.valueOf(request);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveryNode> getFaultyNodes() {
        Object object = this.mutex;
        synchronized (object) {
            return new HashSet<DiscoveryNode>(this.faultyNodes);
        }
    }

    public String toString() {
        return "FollowersChecker{followerCheckInterval=" + String.valueOf(this.followerCheckInterval) + ", followerCheckTimeout=" + String.valueOf(this.followerCheckTimeout) + ", followerCheckRetryCount=" + this.followerCheckRetryCount + ", followerCheckers=" + String.valueOf(this.followerCheckers) + ", faultyNodes=" + String.valueOf(this.faultyNodes) + ", fastResponseState=" + String.valueOf(this.fastResponseState) + "}";
    }

    FastResponseState getFastResponseState() {
        return this.fastResponseState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<DiscoveryNode> getKnownFollowers() {
        Object object = this.mutex;
        synchronized (object) {
            HashSet<DiscoveryNode> knownFollowers = new HashSet<DiscoveryNode>(this.faultyNodes);
            knownFollowers.addAll(this.followerCheckers.keySet());
            return knownFollowers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnectedNode(DiscoveryNode discoveryNode) {
        Object object = this.mutex;
        synchronized (object) {
            FollowerChecker followerChecker = this.followerCheckers.get(discoveryNode);
            if (followerChecker != null && followerChecker.running()) {
                followerChecker.failNode("disconnected");
            }
        }
    }

    static class FastResponseState {
        final long term;
        final Coordinator.Mode mode;

        FastResponseState(long term, Coordinator.Mode mode) {
            this.term = term;
            this.mode = mode;
        }

        public String toString() {
            return "FastResponseState{term=" + this.term + ", mode=" + String.valueOf((Object)this.mode) + "}";
        }
    }

    public static class FollowerCheckRequest
    extends TransportRequest {
        private final long term;
        private final DiscoveryNode sender;

        public long getTerm() {
            return this.term;
        }

        public DiscoveryNode getSender() {
            return this.sender;
        }

        public FollowerCheckRequest(long term, DiscoveryNode sender) {
            this.term = term;
            this.sender = sender;
        }

        public FollowerCheckRequest(StreamInput in) throws IOException {
            super(in);
            this.term = in.readLong();
            this.sender = new DiscoveryNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.term);
            this.sender.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FollowerCheckRequest that = (FollowerCheckRequest)o;
            return this.term == that.term && Objects.equals(this.sender, that.sender);
        }

        public String toString() {
            return "FollowerCheckRequest{term=" + this.term + ", sender=" + String.valueOf(this.sender) + "}";
        }

        public int hashCode() {
            return Objects.hash(this.term, this.sender);
        }
    }

    private class FollowerChecker {
        private final DiscoveryNode discoveryNode;
        private int failureCountSinceLastSuccess;

        FollowerChecker(DiscoveryNode discoveryNode) {
            this.discoveryNode = discoveryNode;
        }

        private boolean running() {
            return this == FollowersChecker.this.followerCheckers.get(this.discoveryNode);
        }

        void start() {
            assert (this.running());
            this.handleWakeUp();
        }

        private void handleWakeUp() {
            if (!this.running()) {
                LOGGER.trace("handleWakeUp: not running");
                return;
            }
            FollowerCheckRequest request = new FollowerCheckRequest(FollowersChecker.this.fastResponseState.term, FollowersChecker.this.transportService.getLocalNode());
            LOGGER.trace("handleWakeUp: checking {} with {}", (Object)this.discoveryNode, (Object)request);
            FollowersChecker.this.transportService.sendRequest(this.discoveryNode, FollowersChecker.FOLLOWER_CHECK_ACTION_NAME, (TransportRequest)request, new TransportRequestOptions(FollowersChecker.this.followerCheckTimeout, TransportRequestOptions.Type.PING), new TransportResponseHandler<TransportResponse.Empty>(){

                @Override
                public TransportResponse.Empty read(StreamInput in) {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (!FollowerChecker.this.running()) {
                        LOGGER.trace("{} no longer running", (Object)FollowerChecker.this);
                        return;
                    }
                    FollowerChecker.this.failureCountSinceLastSuccess = 0;
                    LOGGER.trace("{} check successful", (Object)FollowerChecker.this);
                    FollowerChecker.this.scheduleNextWakeUp();
                }

                @Override
                public void handleException(TransportException exp) {
                    String reason;
                    if (!FollowerChecker.this.running()) {
                        LOGGER.debug((Message)new ParameterizedMessage("{} no longer running", (Object)FollowerChecker.this), (Throwable)exp);
                        return;
                    }
                    ++FollowerChecker.this.failureCountSinceLastSuccess;
                    if (exp instanceof ConnectTransportException || exp.getCause() instanceof ConnectTransportException) {
                        LOGGER.debug(() -> new ParameterizedMessage("{} disconnected", (Object)FollowerChecker.this), (Throwable)exp);
                        reason = "disconnected";
                    } else if (exp.getCause() instanceof NodeHealthCheckFailureException) {
                        LOGGER.debug(() -> new ParameterizedMessage("{} health check failed", (Object)FollowerChecker.this), (Throwable)exp);
                        reason = "health check failed";
                    } else if (FollowerChecker.this.failureCountSinceLastSuccess >= FollowersChecker.this.followerCheckRetryCount) {
                        LOGGER.debug(() -> new ParameterizedMessage("{} failed too many times", (Object)FollowerChecker.this), (Throwable)exp);
                        reason = "followers check retry count exceeded";
                    } else {
                        LOGGER.debug(() -> new ParameterizedMessage("{} failed, retrying", (Object)FollowerChecker.this), (Throwable)exp);
                        FollowerChecker.this.scheduleNextWakeUp();
                        return;
                    }
                    FollowerChecker.this.failNode(reason);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }

        void failNode(final String reason) {
            FollowersChecker.this.transportService.getThreadPool().generic().execute(new Runnable(){
                final /* synthetic */ FollowerChecker this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = this.this$1.FollowersChecker.this.mutex;
                    synchronized (object) {
                        if (!this.this$1.running()) {
                            LOGGER.trace("{} no longer running, not marking faulty", (Object)this.this$1);
                            return;
                        }
                        LOGGER.debug("{} marking node as faulty", (Object)this.this$1);
                        this.this$1.FollowersChecker.this.faultyNodes.add(this.this$1.discoveryNode);
                        this.this$1.FollowersChecker.this.followerCheckers.remove(this.this$1.discoveryNode);
                    }
                    this.this$1.FollowersChecker.this.onNodeFailure.accept(this.this$1.discoveryNode, reason);
                }

                public String toString() {
                    return "detected failure of " + String.valueOf(this.this$1.discoveryNode);
                }
            });
        }

        private void scheduleNextWakeUp() {
            FollowersChecker.this.transportService.getThreadPool().schedule(new Runnable(){

                @Override
                public void run() {
                    FollowerChecker.this.handleWakeUp();
                }

                public String toString() {
                    return String.valueOf(FollowerChecker.this) + "::handleWakeUp";
                }
            }, FollowersChecker.this.followerCheckInterval, "same");
        }

        public String toString() {
            return "FollowerChecker{discoveryNode=" + String.valueOf(this.discoveryNode) + ", failureCountSinceLastSuccess=" + this.failureCountSinceLastSuccess + ", [" + FOLLOWER_CHECK_RETRY_COUNT_SETTING.getKey() + "]=" + FollowersChecker.this.followerCheckRetryCount + "}";
        }
    }
}

