/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.cluster.commands.FixCorruptedMetadataCommand;
import io.crate.server.cli.CommandLoggingConfigurator;
import org.elasticsearch.cli.MultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.coordination.DetachClusterCommand;
import org.elasticsearch.cluster.coordination.RemoveCustomsCommand;
import org.elasticsearch.cluster.coordination.RemoveSettingsCommand;
import org.elasticsearch.cluster.coordination.UnsafeBootstrapMasterCommand;
import org.elasticsearch.env.NodeRepurposeCommand;

public class NodeToolCli
extends MultiCommand {
    public NodeToolCli() {
        super("A CLI tool to do unsafe cluster and index manipulations on current node", () -> {});
        CommandLoggingConfigurator.configureLoggingWithoutConfig();
        this.subcommands.put("repurpose", new NodeRepurposeCommand());
        this.subcommands.put("unsafe-bootstrap", new UnsafeBootstrapMasterCommand());
        this.subcommands.put("detach-cluster", new DetachClusterCommand());
        this.subcommands.put("remove-settings", new RemoveSettingsCommand());
        this.subcommands.put("remove-customs", new RemoveCustomsCommand());
        this.subcommands.put("fix-metadata", new FixCorruptedMetadataCommand());
    }

    public static void main(String[] args) throws Exception {
        try (NodeToolCli nodeToolCli = new NodeToolCli();){
            NodeToolCli.exit((int)nodeToolCli.main(args, Terminal.DEFAULT));
        }
    }
}

