/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.execution.ddl.tables.CreateBlobTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.DocReferences;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.SchemaInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.ToLongFunction;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.ShardLimitValidator;

public class MetadataCreateIndexService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataCreateIndexService.class);
    private final NodeContext nodeContext;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final ShardLimitValidator shardLimitValidator;

    public MetadataCreateIndexService(NodeContext nodeContext, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, ShardLimitValidator shardLimitValidator, Environment env, IndexScopedSettings indexScopedSettings) {
        this.nodeContext = nodeContext;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.shardLimitValidator = shardLimitValidator;
    }

    public static void validateIndexName(String index, ClusterState state) {
        IndexName.validate(index);
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public <T> ActionListener<ClusterStateUpdateResponse> withWaitForShards(ActionListener<T> listener, String indexName, ActiveShardCount waitForActiveShards, TimeValue ackTimeout, BiFunction<Boolean, Boolean, T> createResponse) {
        return ActionListener.wrap(resp -> {
            if (resp.isAcknowledged()) {
                String[] indexNames = new String[]{indexName};
                this.activeShardsObserver.waitForActiveShards(indexNames, waitForActiveShards, ackTimeout, shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        LOGGER.debug("[{}] index created, but the operation timed out waiting for enough shards to be started.", (Object)indexName);
                    }
                    listener.onResponse(createResponse.apply(resp.isAcknowledged(), (Boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(createResponse.apply(false, false));
            }
        }, listener::onFailure);
    }

    public CompletableFuture<ResizeResponse> resizeIndex(ResizeRequest request, IndicesStatsResponse indicesStats) {
        String sourceIndexName = new PartitionName(request.table(), request.partitionValues()).asIndexName();
        IndexStats indexStats = indicesStats.getIndex(sourceIndexName);
        Map<Integer, IndexShardStats> indexShards = indexStats.getIndexShards();
        ResizeIndexTask resizeIndexTask = new ResizeIndexTask(this.allocationService, request, this.indicesService, shardId -> {
            IndexShardStats indexShardStats = (IndexShardStats)indexShards.get(shardId.id());
            if (indexShardStats == null) {
                return 0L;
            }
            DocsStats docs = indexShardStats.getPrimary().getDocs();
            return docs == null ? 0L : docs.getCount();
        }, this.shardLimitValidator, this.indexScopedSettings);
        String source = "resize[" + String.valueOf(request.table()) + "-" + String.valueOf(request.partitionValues()) + "]";
        this.clusterService.submitStateUpdateTask(source, resizeIndexTask);
        return resizeIndexTask.completionFuture().thenCompose(resp -> {
            if (resp.isAcknowledged()) {
                String[] indexNames = new String[]{resizeIndexTask.resizedIndex()};
                return this.activeShardsObserver.waitForActiveShards(indexNames, ActiveShardCount.DEFAULT, request.ackTimeout()).thenApply(shardsAcked -> new ResizeResponse(resp.isAcknowledged(), (boolean)shardsAcked));
            }
            ResizeResponse resizeResponse = new ResizeResponse(false, false);
            return CompletableFuture.completedFuture(resizeResponse);
        });
    }

    public void addBlobTable(CreateBlobTableRequest request, ActionListener<CreateTableResponse> listener) {
        String indexName = request.name().indexNameOrAlias();
        ActionListener<ClusterStateUpdateResponse> stateUpdateListener = this.withWaitForShards(listener, indexName, ActiveShardCount.DEFAULT, request.ackTimeout(), (stateAcked, shardsAcked) -> new CreateTableResponse(stateAcked != false && shardsAcked != false));
        this.clusterService.submitStateUpdateTask("create-blob-table", new CreateBlobTableTask(request, stateUpdateListener, this.indicesService, this.allocationService, this.nodeContext));
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        Path resolvedPath;
        String customPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isNullOrEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isNullOrEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + String.valueOf(this.env.sharedDataFile()) + "]");
        }
        if (forbidPrivateIndexSettings) {
            for (String key : settings.keySet()) {
                Setting<?> setting = this.indexScopedSettings.get(key);
                if (setting == null) {
                    assert (this.indexScopedSettings.isPrivateSetting(key)) : key + " must be a private setting if it is missing";
                    continue;
                }
                if (!setting.isPrivateIndex()) continue;
                validationErrors.add("private index setting [" + key + "] can not be set explicitly");
            }
        }
        return validationErrors;
    }

    static List<String> getShrinkAllocationNodes(ClusterState state, String sourceIndexName, IndexMetadata sourceIndex) {
        IndexRoutingTable table = state.routingTable().index(sourceIndexName);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceIndex.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            AtomicInteger counter = nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), string -> new AtomicInteger(0));
            counter.incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + String.valueOf(sourceIndex) + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(Version.V_5_8_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards << numSplits;
        }
        return numShards;
    }

    public ClusterState add(ClusterState currentState, RelationMetadata.Table table, String newIndexUUID, List<String> partitionValues, Settings concreteIndexSettings) throws IOException {
        String indexName;
        RelationName tableName = table.name();
        if (partitionValues.isEmpty()) {
            indexName = tableName.indexNameOrAlias();
        } else {
            PartitionName partitionName = new PartitionName(tableName, partitionValues);
            indexName = partitionName.asIndexName();
        }
        MetadataCreateIndexService.validateIndexName(indexName, currentState);
        this.validateIndexSettings(indexName, concreteIndexSettings, true);
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        MappingMetadata mapping = new MappingMetadata(Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forNewTable(), table.pkConstraintName(), DocReferences.applyOid(table.columns(), metadataBuilder.columnOidSupplier()), table.primaryKeys(), table.checkConstraints(), table.partitionedBy(), table.columnPolicy(), table.routingColumn())));
        Settings.Builder indexSettingsBuilder = Settings.builder().put(table.settings()).put(concreteIndexSettings).put("index.uuid", newIndexUUID).put("index.creation_date", Instant.now().toEpochMilli());
        Settings idxSettings = indexSettingsBuilder.build();
        this.shardLimitValidator.validateShardLimit(idxSettings, currentState);
        int routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(idxSettings) ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(idxSettings) : MetadataCreateIndexService.calculateNumRoutingShards(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(idxSettings), idxSettings.getAsVersion("index.version.created", null));
        indexSettingsBuilder.remove(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
        IndexMetadata tmpImd = IndexMetadata.builder(indexName).settings(indexSettingsBuilder.build()).setRoutingNumShards(routingNumShards).build();
        ActiveShardCount waitForActiveShards = tmpImd.getWaitForActiveShards();
        if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
            throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(ActiveShardCount.DEFAULT) + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
        }
        return (ClusterState)this.indicesService.withTempIndexService(tmpImd, indexService -> {
            IndexAnalyzers indexAnalyzers = indexService.indexAnalyzers();
            MetadataCreateIndexService.ensureUsedAnalyzersExist(indexAnalyzers, table.columns());
            ClusterState updatedState = MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, metadataBuilder, indexName, tmpImd, mapping, List.of(), routingNumShards);
            SchemaInfo docSchemaInfo = this.nodeContext.schemas().getOrCreateSchemaInfo(tableName.schema());
            docSchemaInfo.create(tableName, updatedState.metadata());
            return updatedState;
        });
    }

    private static ClusterState addIndex(AllocationService allocationService, IndexService indexService, ClusterState currentState, Metadata.Builder metadataBuilder, String indexName, IndexMetadata tmpImd, MappingMetadata mapping, Iterable<Alias> aliases, int routingNumShards) {
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexName).settings(tmpImd.getSettings()).setRoutingNumShards(routingNumShards).state(IndexMetadata.State.OPEN).putMapping(mapping);
        for (int shardId = 0; shardId < tmpImd.getNumberOfShards(); ++shardId) {
            indexMetadataBuilder.primaryTerm(shardId, tmpImd.primaryTerm(shardId));
        }
        for (Alias alias : aliases) {
            AliasMetadata aliasMetadata = new AliasMetadata(alias.name());
            indexMetadataBuilder.putAlias(aliasMetadata);
        }
        IndexMetadata indexMetadata = indexMetadataBuilder.build();
        indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
        LOGGER.info("[{}] creating index, cause [create-table], shards [{}]/[{}]", (Object)indexName, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas());
        Metadata newMetadata = metadataBuilder.put(indexMetadata, false).build();
        ClusterState newState = ClusterState.builder(currentState).blocks(ClusterBlocks.builder().blocks(currentState.blocks()).updateBlocks(indexMetadata)).metadata(newMetadata).routingTable(RoutingTable.builder(currentState.routingTable()).addAsNew(newMetadata.index(indexName)).build()).build();
        return allocationService.reroute(newState, "index [" + indexName + "] created");
    }

    private static void ensureUsedAnalyzersExist(IndexAnalyzers indexAnalyzers, List<Reference> references) {
        for (Reference ref : references) {
            IndexReference indexRef;
            NamedAnalyzer namedAnalyzer;
            if (!(ref instanceof IndexReference) || (namedAnalyzer = indexAnalyzers.get((indexRef = (IndexReference)ref).analyzer())) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Analyzer \"%s\" not found for column \"%s\"", indexRef.analyzer(), indexRef.column()));
        }
    }

    static class ResizeIndexTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final ResizeRequest request;
        private final AllocationService allocationService;
        private final IndexScopedSettings indexScopedSettings;
        private final String sourceIndexName;
        private final String resizedIndexName;
        private final ShardLimitValidator validator;
        private final ToLongFunction<ShardId> getNumDocs;

        ResizeIndexTask(AllocationService allocationService, ResizeRequest request, IndicesService indicesService, ToLongFunction<ShardId> getNumDocs, ShardLimitValidator validator, IndexScopedSettings indexScopedSettings) {
            super(Priority.URGENT, request);
            this.request = request;
            this.allocationService = allocationService;
            this.indicesService = indicesService;
            this.getNumDocs = getNumDocs;
            this.validator = validator;
            this.indexScopedSettings = indexScopedSettings;
            PartitionName partitionName = new PartitionName(request.table(), request.partitionValues());
            this.sourceIndexName = partitionName.asIndexName();
            this.resizedIndexName = ".resized." + this.sourceIndexName;
        }

        public String resizedIndex() {
            return this.resizedIndexName;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Object relation;
            boolean shrink;
            Metadata metadata = currentState.metadata();
            IndexMetadata sourceIndex = metadata.index(this.sourceIndexName);
            if (sourceIndex == null) {
                throw new UnsupportedOperationException("Cannot resize missing index: " + this.sourceIndexName);
            }
            if (metadata.hasIndex(this.resizedIndexName)) {
                throw new ResourceAlreadyExistsException(this.resizedIndexName, new Object[0]);
            }
            if (!currentState.blocks().indexBlocked(ClusterBlockLevel.WRITE, this.sourceIndexName)) {
                throw new IllegalStateException("index " + String.valueOf(sourceIndex) + " must be read-only to resize index. use \"index.blocks.write=true\"");
            }
            Settings sourceSettings = sourceIndex.getSettings();
            Version indexVersionCreated = currentState.nodes().getSmallestNonClientNodeVersion();
            int newNumShards = this.request.newNumShards();
            int routingNumShards = sourceIndex.getNumberOfShards() == 1 ? (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(sourceSettings) ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(sourceSettings) : MetadataCreateIndexService.calculateNumRoutingShards(newNumShards, indexVersionCreated)) : sourceIndex.getRoutingNumShards();
            Settings.Builder indexSettingsBuilder = Settings.builder();
            for (String key : sourceSettings.keySet()) {
                Setting<?> setting = this.indexScopedSettings.get(key);
                if (setting == null) {
                    assert (this.indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                indexSettingsBuilder.copy(key, sourceSettings);
            }
            indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID()).put("index.creation_date", Instant.now().toEpochMilli()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), indexVersionCreated).put(IndexMetadata.INDEX_RESIZE_SOURCE_NAME.getKey(), this.sourceIndexName).put(IndexMetadata.INDEX_RESIZE_SOURCE_UUID.getKey(), sourceIndex.getIndexUUID()).put("index.number_of_shards", newNumShards);
            IndexMetadata.getRoutingFactor(sourceIndex.getNumberOfShards(), newNumShards);
            boolean bl = shrink = sourceIndex.getNumberOfShards() > newNumShards;
            if (shrink) {
                List<String> nodesToAllocateOn = MetadataCreateIndexService.getShrinkAllocationNodes(currentState, this.sourceIndexName, sourceIndex);
                indexSettingsBuilder.put(IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id", Lists.joinOn((String)",", nodesToAllocateOn, x -> x));
            }
            for (int i = 0; i < newNumShards; ++i) {
                if (shrink) {
                    Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, sourceIndex, newNumShards);
                    long count = 0L;
                    for (ShardId id : shardIds) {
                        if ((count += this.getNumDocs.applyAsLong(id)) <= 0x7FFFFF7FL) continue;
                        throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + String.valueOf(shardIds));
                    }
                    continue;
                }
                Objects.requireNonNull(IndexMetadata.selectSplitShard(i, sourceIndex, newNumShards));
            }
            IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(this.resizedIndexName).settings(indexSettingsBuilder).setRoutingNumShards(routingNumShards);
            assert (tmpImdBuilder.numberOfShards() == newNumShards) : "number of shards must be set";
            long primaryTerm = IntStream.range(0, sourceIndex.getNumberOfShards()).mapToLong(sourceIndex::primaryTerm).max().getAsLong();
            for (int shardId = 0; shardId < tmpImdBuilder.numberOfShards(); ++shardId) {
                tmpImdBuilder.primaryTerm(shardId, primaryTerm);
            }
            Metadata.Builder metadataBuilder = Metadata.builder(metadata);
            if (this.request.partitionValues().isEmpty() && (relation = metadata.getRelation(this.request.table())) instanceof RelationMetadata.Table) {
                RelationMetadata.Table table = (RelationMetadata.Table)relation;
                metadataBuilder.setTable(table.name(), table.columns(), Settings.builder().put(table.settings()).put("index.number_of_shards", newNumShards).build(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), table.indexUUIDs(), table.tableVersion() + 1L);
            }
            IndexMetadata tmpImd = tmpImdBuilder.build();
            this.validator.validateShardLimit(tmpImd.getSettings(), currentState);
            return (ClusterState)this.indicesService.withTempIndexService(tmpImd, indexService -> MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, metadataBuilder, this.resizedIndexName, indexService.getMetadata(), sourceIndex.mapping(), this.request.partitionValues().isEmpty() ? List.of() : List.of(new Alias(this.request.table().indexNameOrAlias())), routingNumShards));
        }
    }

    static class CreateBlobTableTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final CreateBlobTableRequest request;
        private final AllocationService allocationService;
        private final NodeContext nodeContext;

        public CreateBlobTableTask(CreateBlobTableRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, AllocationService allocationService, NodeContext nodeContext) {
            super(Priority.HIGH, request, listener);
            this.request = request;
            this.indicesService = indicesService;
            this.allocationService = allocationService;
            this.nodeContext = nodeContext;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            RelationName relationName = this.request.name();
            String indexName = relationName.indexNameOrAlias();
            Version versionCreated = currentState.nodes().getSmallestNonClientNodeVersion();
            String indexUUID = UUIDs.randomBase64UUID();
            Settings settings = Settings.builder().put(this.request.settings()).put("index.uuid", indexUUID).put("index.creation_date", Instant.now().toEpochMilli()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), versionCreated).build();
            int numShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
            IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(settings).build();
            return (ClusterState)this.indicesService.withTempIndexService(indexMetadata, indexService -> {
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata()).setBlobTable(relationName, indexUUID, settings, IndexMetadata.State.OPEN);
                ClusterState updatedState = MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, mdBuilder, indexName, indexMetadata, new MappingMetadata(Map.of()), List.of(), MetadataCreateIndexService.calculateNumRoutingShards(numShards, versionCreated));
                SchemaInfo blobSchemaInfo = this.nodeContext.schemas().getSchemaInfo("blob");
                assert (blobSchemaInfo != null) : "BlobSchemaInfo should be available";
                blobSchemaInfo.create(this.request.name(), updatedState.metadata());
                return updatedState;
            });
        }
    }
}

