/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import io.crate.common.unit.TimeValue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class DelayedAllocationService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(DelayedAllocationService.class);
    static final String CLUSTER_UPDATE_TASK_SOURCE = "delayed_allocation_reroute";
    final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    AtomicReference<DelayedRerouteTask> delayedRerouteTask = new AtomicReference();

    @Inject
    public DelayedAllocationService(ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        if (DiscoveryNode.isMasterEligibleNode(clusterService.getSettings())) {
            clusterService.addListener(this);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
        this.removeTaskAndCancel();
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            long currentNanoTime = this.currentNanoTime();
            this.scheduleIfNeeded(currentNanoTime, event.state());
        }
    }

    private void removeTaskAndCancel() {
        DelayedRerouteTask existingTask = this.delayedRerouteTask.getAndSet(null);
        if (existingTask != null) {
            LOGGER.trace("cancelling existing delayed reroute task");
            existingTask.cancelScheduling();
        }
    }

    private void removeIfSameTask(DelayedRerouteTask expectedTask) {
        this.delayedRerouteTask.compareAndSet(expectedTask, null);
    }

    private synchronized void scheduleIfNeeded(long currentNanoTime, ClusterState state) {
        this.assertClusterOrMasterStateThread();
        long nextDelayNanos = UnassignedInfo.findNextDelayedAllocation(currentNanoTime, state);
        if (nextDelayNanos < 0L) {
            LOGGER.trace("no need to schedule reroute - no delayed unassigned shards");
            this.removeTaskAndCancel();
        } else {
            boolean earlierRerouteNeeded;
            TimeValue nextDelay = TimeValue.timeValueNanos((long)nextDelayNanos);
            DelayedRerouteTask existingTask = this.delayedRerouteTask.get();
            DelayedRerouteTask newTask = new DelayedRerouteTask(nextDelay, currentNanoTime);
            if (existingTask == null) {
                earlierRerouteNeeded = true;
            } else if (newTask.scheduledTimeToRunInNanos() < existingTask.scheduledTimeToRunInNanos()) {
                LOGGER.trace("cancelling existing delayed reroute task as delayed reroute has to happen [{}] earlier", (Object)TimeValue.timeValueNanos((long)(existingTask.scheduledTimeToRunInNanos() - newTask.scheduledTimeToRunInNanos())));
                existingTask.cancelScheduling();
                earlierRerouteNeeded = true;
            } else {
                earlierRerouteNeeded = false;
            }
            if (earlierRerouteNeeded) {
                LOGGER.info("scheduling reroute for delayed shards in [{}] ({} delayed shards)", (Object)nextDelay, (Object)UnassignedInfo.getNumberOfDelayedUnassigned(state));
                DelayedRerouteTask currentTask = this.delayedRerouteTask.getAndSet(newTask);
                assert (existingTask == currentTask || currentTask == null);
                newTask.schedule();
            } else {
                LOGGER.trace("no need to reschedule delayed reroute - currently scheduled delayed reroute in [{}] is enough", (Object)nextDelay);
            }
        }
    }

    protected void assertClusterOrMasterStateThread() {
        assert (ClusterService.assertClusterOrMasterStateThread());
    }

    class DelayedRerouteTask
    extends ClusterStateUpdateTask {
        final TimeValue nextDelay;
        final long baseTimestampNanos;
        volatile Scheduler.Cancellable cancellable;
        final AtomicBoolean cancelScheduling = new AtomicBoolean();

        DelayedRerouteTask(TimeValue nextDelay, long baseTimestampNanos) {
            this.nextDelay = nextDelay;
            this.baseTimestampNanos = baseTimestampNanos;
        }

        public long scheduledTimeToRunInNanos() {
            return this.baseTimestampNanos + this.nextDelay.nanos();
        }

        public void cancelScheduling() {
            this.cancelScheduling.set(true);
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
            DelayedAllocationService.this.removeIfSameTask(this);
        }

        public void schedule() {
            this.cancellable = DelayedAllocationService.this.threadPool.schedule(new RejectableRunnable(){

                @Override
                public void doRun() throws Exception {
                    if (DelayedRerouteTask.this.cancelScheduling.get()) {
                        return;
                    }
                    DelayedAllocationService.this.clusterService.submitStateUpdateTask(DelayedAllocationService.CLUSTER_UPDATE_TASK_SOURCE, DelayedRerouteTask.this);
                }

                @Override
                public void onFailure(Exception e) {
                    LOGGER.warn("failed to submit schedule/execute reroute post unassigned shard", (Throwable)e);
                    DelayedAllocationService.this.removeIfSameTask(DelayedRerouteTask.this);
                }
            }, this.nextDelay, "same");
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            DelayedAllocationService.this.removeIfSameTask(this);
            return DelayedAllocationService.this.allocationService.reroute(currentState, "assign delayed unassigned shards");
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (oldState == newState) {
                DelayedAllocationService.this.scheduleIfNeeded(DelayedAllocationService.this.currentNanoTime(), newState);
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            DelayedAllocationService.this.removeIfSameTask(this);
            LOGGER.warn("failed to schedule/execute reroute post unassigned shard", (Throwable)e);
        }
    }
}

