/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import io.crate.common.unit.TimeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.service.BatchedTask;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public final class TaskBatcher<T> {
    private final Logger logger;
    private final PrioritizedEsThreadPoolExecutor threadExecutor;
    final Map<ClusterStateTaskExecutor<T>, LinkedHashSet<BatchedTask<T>>> tasksPerBatchingKey = new HashMap<ClusterStateTaskExecutor<T>, LinkedHashSet<BatchedTask<T>>>();
    private final Consumer<MasterService.TaskInputs<T>> runTasks;
    private final Executor genericExecutor;

    public TaskBatcher(Logger logger, Executor genericExecutor, PrioritizedEsThreadPoolExecutor threadExecutor, Consumer<MasterService.TaskInputs<T>> runTasks) {
        this.logger = logger;
        this.genericExecutor = genericExecutor;
        this.threadExecutor = threadExecutor;
        this.runTasks = runTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTasks(List<BatchedTask<T>> tasks, @Nullable TimeValue timeout) throws EsRejectedExecutionException {
        if (tasks.isEmpty()) {
            return;
        }
        BatchedTask<T> firstTask = tasks.get(0);
        assert (tasks.stream().allMatch(t -> t.batchingKey == firstTask.batchingKey)) : "tasks submitted in a batch should share the same batching key: " + String.valueOf(tasks);
        Map tasksIdentity = tasks.stream().collect(Collectors.toMap(BatchedTask::getTask, Function.identity(), (a, b) -> {
            throw new IllegalStateException("cannot add duplicate task: " + String.valueOf(a));
        }, IdentityHashMap::new));
        Map<ClusterStateTaskExecutor<T>, LinkedHashSet<BatchedTask<T>>> map = this.tasksPerBatchingKey;
        synchronized (map) {
            LinkedHashSet existingTasks = this.tasksPerBatchingKey.computeIfAbsent(firstTask.batchingKey, k -> new LinkedHashSet(tasks.size()));
            for (BatchedTask existing : existingTasks) {
                BatchedTask duplicateTask = (BatchedTask)tasksIdentity.get(existing.getTask());
                if (duplicateTask == null) continue;
                throw new IllegalStateException("task [" + duplicateTask.describeTasks(Collections.singletonList(existing)) + "] with source [" + duplicateTask.source() + "] is already queued");
            }
            existingTasks.addAll(tasks);
        }
        if (timeout != null) {
            this.threadExecutor.execute(firstTask, timeout, () -> this.onTimeoutInternal(tasks, timeout));
        } else {
            this.threadExecutor.execute(firstTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeoutInternal(List<BatchedTask<T>> tasks, TimeValue timeout) {
        ArrayList<BatchedTask<T>> toRemove = new ArrayList<BatchedTask<T>>();
        for (BatchedTask<T> task : tasks) {
            if (task.processed.getAndSet(true)) continue;
            this.logger.debug("task [{}] timed out after [{}]", (Object)task.source(), (Object)timeout);
            toRemove.add(task);
        }
        if (!toRemove.isEmpty()) {
            BatchedTask firstTask = (BatchedTask)toRemove.get(0);
            ClusterStateTaskExecutor batchingKey = firstTask.batchingKey;
            assert (tasks.stream().allMatch(t -> t.batchingKey == batchingKey)) : "tasks submitted in a batch should share the same batching key: " + String.valueOf(tasks);
            Map<ClusterStateTaskExecutor<T>, LinkedHashSet<BatchedTask<T>>> map = this.tasksPerBatchingKey;
            synchronized (map) {
                LinkedHashSet<BatchedTask<T>> existingTasks = this.tasksPerBatchingKey.get(batchingKey);
                if (existingTasks != null) {
                    existingTasks.removeAll(toRemove);
                    if (existingTasks.isEmpty()) {
                        this.tasksPerBatchingKey.remove(batchingKey);
                    }
                }
            }
            this.onTimeout(toRemove, timeout);
        }
    }

    protected void onTimeout(List<BatchedTask<T>> tasks, TimeValue timeout) {
        this.genericExecutor.execute(() -> tasks.forEach(task -> task.listener.onFailure(task.source(), new ProcessClusterEventTimeoutException(timeout, task.source()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runIfNotProcessed(BatchedTask<T> updateTask) {
        if (!updateTask.processed.get()) {
            ArrayList toExecute = new ArrayList();
            HashMap<String, List> processTasksBySource = new HashMap<String, List>();
            Map<ClusterStateTaskExecutor<T>, LinkedHashSet<BatchedTask<T>>> map = this.tasksPerBatchingKey;
            synchronized (map) {
                LinkedHashSet<BatchedTask<T>> pending = this.tasksPerBatchingKey.remove(updateTask.batchingKey);
                if (pending != null) {
                    for (BatchedTask batchedTask : pending) {
                        if (!batchedTask.processed.getAndSet(true)) {
                            this.logger.trace("will process {}", (Object)batchedTask);
                            toExecute.add(batchedTask);
                            processTasksBySource.computeIfAbsent(batchedTask.source(), s -> new ArrayList()).add(batchedTask);
                            continue;
                        }
                        this.logger.trace("skipping {}, already processed", (Object)batchedTask);
                    }
                }
            }
            if (!toExecute.isEmpty()) {
                String tasksSummary = processTasksBySource.entrySet().stream().map(entry -> {
                    String tasks = updateTask.describeTasks((List)entry.getValue());
                    return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
                }).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
                this.runTasks.accept(new MasterService.TaskInputs(tasksSummary, toExecute, updateTask.batchingKey));
            }
        }
    }
}

