/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1) throws IOException;

    public InputStream readBlob(String var1) throws IOException;

    default public InputStream readBlob(String blobName, long position, long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public long readBlobPreferredLength() {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    default public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public void delete() throws IOException;

    public void deleteBlobsIgnoringIfNotExists(List<String> var1) throws IOException;

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetadata> listBlobs() throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(String var1) throws IOException;
}

