/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ParseField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Circle;

public class CircleBuilder
extends ShapeBuilder<Circle, CircleBuilder> {
    public static final ParseField FIELD_RADIUS = new ParseField("radius", new String[0]);
    public static final GeoShapeType TYPE = GeoShapeType.CIRCLE;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private double radius;
    private Coordinate center = ZERO_ZERO;

    public CircleBuilder center(Coordinate center) {
        this.center = center;
        return this;
    }

    public CircleBuilder radius(DistanceUnit.Distance radius) {
        return this.radius(radius.value, radius.unit);
    }

    public CircleBuilder radius(double radius, DistanceUnit unit) {
        this.unit = unit;
        this.radius = radius;
        return this;
    }

    @Override
    public Circle buildS4J() {
        return SHAPE_FACTORY.circle(this.center.x, this.center.y, 360.0 * this.radius / this.unit.getEarthCircumference());
    }

    @Override
    public Object buildLucene() {
        throw new UnsupportedOperationException("CIRCLE geometry is not supported");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.center, this.radius, this.unit.ordinal());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CircleBuilder other = (CircleBuilder)obj;
        return Objects.equals(this.center, other.center) && Objects.equals(this.radius, other.radius) && Objects.equals(this.unit.ordinal(), other.unit.ordinal());
    }
}

