/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class GeometryCollectionBuilder
extends ShapeBuilder {
    public static final GeoShapeType TYPE = GeoShapeType.GEOMETRYCOLLECTION;
    final List<ShapeBuilder> shapes = new ArrayList<ShapeBuilder>();

    public GeometryCollectionBuilder shape(ShapeBuilder shape) {
        this.shapes.add(shape);
        return this;
    }

    public Shape buildS4J() {
        ArrayList shapes = new ArrayList(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            shapes.add(shape.buildS4J());
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    @Override
    public Object buildLucene() {
        ArrayList<Object> shapes = new ArrayList<Object>(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            Object o = shape.buildLucene();
            if (o.getClass().isArray()) {
                shapes.addAll(Arrays.asList((Object[])o));
                continue;
            }
            shapes.add(o);
        }
        if (shapes.size() == 1) {
            return shapes.get(0);
        }
        return shapes.toArray(new Object[shapes.size()]);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.shapes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollectionBuilder other = (GeometryCollectionBuilder)obj;
        return Objects.equals(this.shapes, other.shapes);
    }
}

