/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;
    public static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        long l;
        block6: {
            block5: {
                Objects.requireNonNull(in, "No InputStream specified");
                Objects.requireNonNull(out, "No OutputStream specified");
                boolean success = false;
                try {
                    int bytesRead;
                    long byteCount = 0L;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        byteCount += (long)bytesRead;
                    }
                    out.flush();
                    success = true;
                    l = byteCount;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in, out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in, out});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
        }
        return l;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static BytesReference readFully(InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            BytesStreamOutput out = new BytesStreamOutput();
            io.crate.common.io.Streams.copy((InputStream)inputStream, (OutputStream)out);
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
    }

    public static long consumeFully(InputStream inputStream) throws IOException {
        return io.crate.common.io.Streams.copy((InputStream)inputStream, (OutputStream)NULL_OUTPUT_STREAM);
    }

    public static InputStream limitStream(InputStream in, long limit) {
        return new LimitedInputStream(in, limit);
    }

    public static BytesStream flushOnCloseStream(BytesStream os) {
        return new FlushOnCloseOutputStream(os);
    }

    static class LimitedInputStream
    extends FilterInputStream {
        private static final long NO_MARK = -1L;
        private long currentLimit;
        private long limitOnLastMark;

        LimitedInputStream(InputStream in, long limit) {
            super(in);
            if (limit < 0L) {
                throw new IllegalArgumentException("limit must be non-negative");
            }
            this.currentLimit = limit;
            this.limitOnLastMark = -1L;
        }

        @Override
        public int read() throws IOException {
            int result;
            if (this.currentLimit == 0L || (result = this.in.read()) == -1) {
                return -1;
            }
            --this.currentLimit;
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            if (this.currentLimit == 0L || (result = this.in.read(b, off, Math.toIntExact(Math.min((long)len, this.currentLimit)))) == -1) {
                return -1;
            }
            this.currentLimit -= (long)result;
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = this.in.skip(Math.min(n, this.currentLimit));
            this.currentLimit -= skipped;
            return skipped;
        }

        @Override
        public int available() throws IOException {
            return Math.toIntExact(Math.min((long)this.in.available(), this.currentLimit));
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.limitOnLastMark = this.currentLimit;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
            if (this.limitOnLastMark != -1L) {
                this.currentLimit = this.limitOnLastMark;
            }
        }
    }

    private static class FlushOnCloseOutputStream
    extends BytesStream {
        private final BytesStream delegate;

        private FlushOnCloseOutputStream(BytesStream bytesStreamOutput) {
            this.delegate = bytesStreamOutput;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public BytesReference bytes() {
            return this.delegate.bytes();
        }
    }
}

