/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import io.crate.common.unit.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.NodeAndClusterIdConverter;

public class NodeAndClusterIdStateListener
implements ClusterStateObserver.Listener {
    private static final Logger LOGGER = LogManager.getLogger(NodeAndClusterIdStateListener.class);

    private NodeAndClusterIdStateListener() {
    }

    public static void getAndSetNodeIdAndClusterId(ClusterService clusterService) {
        ClusterState clusterState = clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService.getClusterApplierService(), null, LOGGER);
        observer.waitForNextChange((ClusterStateObserver.Listener)new NodeAndClusterIdStateListener(), NodeAndClusterIdStateListener::isNodeAndClusterIdPresent);
    }

    private static boolean isNodeAndClusterIdPresent(ClusterState clusterState) {
        return NodeAndClusterIdStateListener.getNodeId(clusterState) != null && NodeAndClusterIdStateListener.getClusterUUID(clusterState) != null;
    }

    private static String getClusterUUID(ClusterState state) {
        return state.metadata().clusterUUID();
    }

    private static String getNodeId(ClusterState state) {
        return state.nodes().getLocalNodeId();
    }

    @Override
    public void onNewClusterState(ClusterState state) {
        String nodeId = NodeAndClusterIdStateListener.getNodeId(state);
        String clusterUUID = NodeAndClusterIdStateListener.getClusterUUID(state);
        LOGGER.debug("Received cluster state update. Setting nodeId=[{}] and clusterUuid=[{}]", (Object)nodeId, (Object)clusterUUID);
        NodeAndClusterIdConverter.setNodeIdAndClusterId(nodeId, clusterUUID);
    }

    @Override
    public void onClusterServiceClose() {
    }

    @Override
    public void onTimeout(TimeValue timeout) {
    }
}

