/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class MinimumScoreCollector<T extends Collector>
implements Collector {
    private final T collector;
    private final float minimumScore;

    public MinimumScoreCollector(T collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    public T delegate() {
        return this.collector;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final LeafCollector delegateLeafCollector = this.collector.getLeafCollector(context);
        return ScoreCachingWrappingScorer.wrap((LeafCollector)new LeafCollector(){
            Scorable scorer;
            final /* synthetic */ MinimumScoreCollector this$0;
            {
                this.this$0 = this$0;
            }

            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                delegateLeafCollector.setScorer(scorer);
            }

            public void collect(int doc) throws IOException {
                if (this.scorer.score() >= this.this$0.minimumScore) {
                    delegateLeafCollector.collect(doc);
                }
            }
        });
    }

    public void setWeight(Weight weight) {
        this.collector.setWeight(weight);
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }
}

