/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import io.crate.common.unit.TimeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;

public class PrioritizedEsThreadPoolExecutor
extends EsThreadPoolExecutor {
    private static final TimeValue NO_WAIT_TIME_VALUE = TimeValue.timeValueMillis((long)0L);
    private final AtomicLong insertionOrder = new AtomicLong();
    private final Queue<Runnable> current = new ConcurrentLinkedQueue<Runnable>();
    private final ScheduledExecutorService timer;

    public PrioritizedEsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ScheduledExecutorService timer) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory);
        this.timer = timer;
    }

    public List<Pending> getPending() {
        ArrayList<Pending> pending = new ArrayList<Pending>();
        this.addPending(this.current, pending, true);
        this.addPending(this.getQueue(), pending, false);
        return pending;
    }

    public int getNumberOfPendingTasks() {
        int size = this.current.size();
        return size += this.getQueue().size();
    }

    public TimeValue getMaxTaskWaitTime() {
        long now;
        if (this.getQueue().size() == 0) {
            return NO_WAIT_TIME_VALUE;
        }
        long oldestCreationDateInNanos = now = System.nanoTime();
        for (Runnable queuedRunnable : this.getQueue()) {
            if (!(queuedRunnable instanceof PrioritizedRunnable)) continue;
            oldestCreationDateInNanos = Math.min(oldestCreationDateInNanos, ((PrioritizedRunnable)queuedRunnable).getCreationDateInNanos());
        }
        return TimeValue.timeValueNanos((long)(now - oldestCreationDateInNanos));
    }

    private void addPending(Collection<Runnable> runnables, List<Pending> pending, boolean executing) {
        for (Runnable runnable : runnables) {
            if (!(runnable instanceof TieBreakingPrioritizedRunnable)) continue;
            TieBreakingPrioritizedRunnable tieBreaking = (TieBreakingPrioritizedRunnable)runnable;
            PrioritizedRunnable innerRunnable = tieBreaking.runnable;
            if (innerRunnable == null) continue;
            pending.add(new Pending(innerRunnable, tieBreaking.priority(), tieBreaking.insertionOrder, executing));
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.current.add(r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.current.remove(r);
    }

    public void execute(Runnable command, TimeValue timeout, Runnable timeoutCallback) {
        TieBreakingPrioritizedRunnable tieBreaking = this.wrapRunnable(command);
        this.execute(tieBreaking);
        if (timeout.nanos() >= 0L) {
            tieBreaking.scheduleTimeout(this.timer, timeoutCallback, timeout);
        }
    }

    @Override
    protected TieBreakingPrioritizedRunnable wrapRunnable(Runnable command) {
        if (command instanceof TieBreakingPrioritizedRunnable) {
            TieBreakingPrioritizedRunnable tieBreaking = (TieBreakingPrioritizedRunnable)command;
            return tieBreaking;
        }
        if (command instanceof PrioritizedRunnable) {
            PrioritizedRunnable prioritized = (PrioritizedRunnable)command;
            Priority priority = prioritized.priority();
            return new TieBreakingPrioritizedRunnable(prioritized, priority, this.insertionOrder.incrementAndGet());
        }
        throw new UnsupportedOperationException("Cannot run non-prioritized runnable with " + this.getClass().getSimpleName());
    }

    private final class TieBreakingPrioritizedRunnable
    extends PrioritizedRunnable
    implements WrappedRunnable {
        private PrioritizedRunnable runnable;
        private final long insertionOrder;
        private ScheduledFuture<?> timeoutFuture;
        private boolean started;

        TieBreakingPrioritizedRunnable(PrioritizedRunnable runnable, Priority priority, long insertionOrder) {
            super(priority, runnable.source());
            this.started = false;
            this.runnable = runnable;
            this.insertionOrder = insertionOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TieBreakingPrioritizedRunnable tieBreakingPrioritizedRunnable = this;
            synchronized (tieBreakingPrioritizedRunnable) {
                this.started = true;
                FutureUtils.cancel(this.timeoutFuture);
            }
            this.runAndClean(this.runnable);
        }

        @Override
        public int compareTo(PrioritizedRunnable pr) {
            int res = super.compareTo(pr);
            if (res != 0 || !(pr instanceof TieBreakingPrioritizedRunnable)) {
                return res;
            }
            return this.insertionOrder < ((TieBreakingPrioritizedRunnable)pr).insertionOrder ? -1 : 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(ScheduledExecutorService timer, final Runnable timeoutCallback, TimeValue timeValue) {
            TieBreakingPrioritizedRunnable tieBreakingPrioritizedRunnable = this;
            synchronized (tieBreakingPrioritizedRunnable) {
                if (this.timeoutFuture != null) {
                    throw new IllegalStateException("scheduleTimeout may only be called once");
                }
                if (!this.started) {
                    this.timeoutFuture = timer.schedule(new Runnable(){
                        final /* synthetic */ TieBreakingPrioritizedRunnable this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.PrioritizedEsThreadPoolExecutor.this.remove(this.this$1)) {
                                this.this$1.runAndClean(timeoutCallback);
                            }
                        }
                    }, timeValue.nanos(), TimeUnit.NANOSECONDS);
                }
            }
        }

        private void runAndClean(Runnable run) {
            try {
                run.run();
            }
            finally {
                this.runnable = null;
                this.timeoutFuture = null;
            }
        }

        @Override
        public PrioritizedRunnable unwrap() {
            return this.runnable;
        }
    }

    public record Pending(PrioritizedRunnable task, Priority priority, long insertionOrder, boolean executing) {
    }
}

