/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;

public class PriorityRunnable {
    private PriorityRunnable() {
    }

    public static PrioritizedRunnable of(Priority priority, String source, Runnable runnable) {
        PrioritizedRunnable prioritizedRunnable;
        if (runnable instanceof RejectableRunnable) {
            RejectableRunnable rejectableRunnable = (RejectableRunnable)runnable;
            prioritizedRunnable = new RejectablePriorityRunnable(priority, source, rejectableRunnable);
        } else {
            prioritizedRunnable = new SimplePriorityRunnable(priority, source, runnable);
        }
        return prioritizedRunnable;
    }

    public static class RejectablePriorityRunnable
    extends PrioritizedRunnable
    implements RejectableRunnable,
    WrappedRunnable {
        private final RejectableRunnable runnable;

        private RejectablePriorityRunnable(Priority priority, String source, RejectableRunnable runnable) {
            super(priority, source);
            this.runnable = runnable;
        }

        @Override
        public void onFailure(Exception e) {
            this.runnable.onFailure(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.runnable.onRejection(e);
        }

        @Override
        public boolean isForceExecution() {
            return this.runnable.isForceExecution();
        }

        @Override
        public void doRun() throws Exception {
            this.runnable.doRun();
        }

        @Override
        public Runnable unwrap() {
            return this.runnable;
        }

        @Override
        public String toString() {
            return "[" + this.source + "/" + String.valueOf((Object)this.priority()) + "=" + String.valueOf(this.runnable) + "]";
        }
    }

    public static class SimplePriorityRunnable
    extends PrioritizedRunnable
    implements WrappedRunnable {
        private final Runnable runnable;

        private SimplePriorityRunnable(Priority priority, String source, Runnable runnable) {
            super(priority, source);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public Runnable unwrap() {
            return this.runnable;
        }

        @Override
        public String toString() {
            return "[" + this.source + "/" + String.valueOf((Object)this.priority()) + "=" + String.valueOf(this.runnable) + "]";
        }
    }
}

