/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class HandshakingTransportAddressConnector
implements PeerFinder.TransportAddressConnector {
    private static final Logger LOGGER = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.connect_timeout", TimeValue.timeValueMillis((long)3000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.handshake_timeout", TimeValue.timeValueMillis((long)1000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TransportService transportService;
    private final TimeValue probeConnectTimeout;
    private final TimeValue probeHandshakeTimeout;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.probeConnectTimeout = PROBE_CONNECT_TIMEOUT_SETTING.get(settings);
        this.probeHandshakeTimeout = PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public void connectToRemoteMasterNode(final TransportAddress transportAddress, final ActionListener<DiscoveryNode> listener) {
        this.transportService.getThreadPool().generic().execute(new RejectableRunnable(){
            private final RejectableRunnable thisConnectionAttempt = this;
            final /* synthetic */ HandshakingTransportAddressConnector this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void doRun() {
                DiscoveryNode targetNode = new DiscoveryNode("", transportAddress.toString(), UUIDs.randomBase64UUID(Randomness.get()), transportAddress.address().getHostString(), transportAddress.getAddress(), transportAddress, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion());
                LOGGER.trace("[{}] opening probe connection", (Object)this.thisConnectionAttempt);
                this.this$0.transportService.openConnection(targetNode, ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, this.this$0.probeConnectTimeout, this.this$0.probeHandshakeTimeout, TimeValue.MINUS_ONE, null), new ActionListener<Transport.Connection>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void onResponse(final Transport.Connection connection) {
                        LOGGER.trace("[{}] opened probe connection", (Object)this.this$1.thisConnectionAttempt);
                        this.this$1.this$0.transportService.handshake(connection, this.this$1.this$0.probeHandshakeTimeout.millis(), (ActionListener<DiscoveryNode>)new NotifyOnceListener<DiscoveryNode>(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            protected void innerOnResponse(final DiscoveryNode remoteNode) {
                                try {
                                    LOGGER.trace("[{}] handshake successful: {}", (Object)this.this$2.this$1.thisConnectionAttempt, (Object)remoteNode);
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                                    if (remoteNode.equals(this.this$2.this$1.this$0.transportService.getLocalNode())) {
                                        listener.onFailure(new ConnectTransportException(remoteNode, "local node found"));
                                    } else if (!remoteNode.isMasterEligibleNode()) {
                                        listener.onFailure(new ConnectTransportException(remoteNode, "non-master-eligible node found"));
                                    } else {
                                        this.this$2.this$1.this$0.transportService.connectToNode(remoteNode, new ActionListener<Void>(){
                                            final /* synthetic */ 1 this$3;
                                            {
                                                this.this$3 = this$3;
                                            }

                                            @Override
                                            public void onResponse(Void ignored) {
                                                LOGGER.trace("[{}] full connection successful: {}", (Object)this.this$3.this$2.this$1.thisConnectionAttempt, (Object)remoteNode);
                                                listener.onResponse(remoteNode);
                                            }

                                            @Override
                                            public void onFailure(Exception e) {
                                                LOGGER.warn((Message)new ParameterizedMessage("[{}] completed handshake with [{}] but followup connection failed", (Object)this.this$3.this$2.this$1.thisConnectionAttempt, (Object)remoteNode), (Throwable)e);
                                                listener.onFailure(e);
                                            }
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    listener.onFailure(e);
                                }
                            }

                            @Override
                            protected void innerOnFailure(Exception e) {
                                SendRequestTransportException transportException;
                                boolean nodeClosed;
                                boolean bl = nodeClosed = e instanceof AlreadyClosedException || e instanceof SendRequestTransportException && (transportException = (SendRequestTransportException)e).getCause() instanceof NodeClosedException;
                                if (!nodeClosed) {
                                    LOGGER.warn((Message)new ParameterizedMessage("handshake failed for [{}]", (Object)this.this$2.this$1.thisConnectionAttempt), (Throwable)e);
                                }
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                                listener.onFailure(e);
                            }
                        });
                    }

                    @Override
                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public String toString() {
                return "connectToRemoteMasterNode[" + String.valueOf(transportAddress) + "]";
            }
        });
    }
}

