/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.coordination.PeersResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.discovery.PeersRequest;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public abstract class PeerFinder {
    private static final Logger LOGGER = LogManager.getLogger(PeerFinder.class);
    public static final String REQUEST_PEERS_ACTION_NAME = "internal:discovery/request_peers";
    public static final Setting<TimeValue> DISCOVERY_FIND_PEERS_INTERVAL_SETTING = Setting.timeSetting("discovery.find_peers_interval", TimeValue.timeValueMillis((long)1000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING = Setting.timeSetting("discovery.request_peers_timeout", TimeValue.timeValueMillis((long)3000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TimeValue findPeersInterval;
    private final TimeValue requestPeersTimeout;
    private final Object mutex = new Object();
    private final TransportService transportService;
    private final TransportAddressConnector transportAddressConnector;
    private final ConfiguredHostsResolver configuredHostsResolver;
    private volatile long currentTerm;
    private boolean active;
    private DiscoveryNodes lastAcceptedNodes;
    private final Map<TransportAddress, Peer> peersByAddress = new LinkedHashMap<TransportAddress, Peer>();
    private Optional<DiscoveryNode> leader = Optional.empty();
    private volatile List<TransportAddress> lastResolvedAddresses = Collections.emptyList();

    public PeerFinder(Settings settings, TransportService transportService, TransportAddressConnector transportAddressConnector, ConfiguredHostsResolver configuredHostsResolver) {
        this.findPeersInterval = DISCOVERY_FIND_PEERS_INTERVAL_SETTING.get(settings);
        this.requestPeersTimeout = DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING.get(settings);
        this.transportService = transportService;
        this.transportAddressConnector = transportAddressConnector;
        this.configuredHostsResolver = configuredHostsResolver;
        transportService.registerRequestHandler(REQUEST_PEERS_ACTION_NAME, "generic", false, false, PeersRequest::new, (request, channel) -> channel.sendResponse(this.handlePeersRequest((PeersRequest)request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DiscoveryNodes lastAcceptedNodes) {
        LOGGER.trace("activating with {}", (Object)lastAcceptedNodes);
        Object object = this.mutex;
        synchronized (object) {
            assert (this.assertInactiveWithNoKnownPeers());
            this.active = true;
            this.lastAcceptedNodes = lastAcceptedNodes;
            this.leader = Optional.empty();
            this.handleWakeUp();
        }
        this.onFoundPeersUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DiscoveryNode leader) {
        boolean peersRemoved;
        Object object = this.mutex;
        synchronized (object) {
            LOGGER.trace("deactivating and setting leader to {}", (Object)leader);
            this.active = false;
            peersRemoved = this.handleWakeUp();
            this.leader = Optional.of(leader);
            assert (this.assertInactiveWithNoKnownPeers());
        }
        if (peersRemoved) {
            this.onFoundPeersUpdated();
        }
    }

    protected final boolean holdsLock() {
        return Thread.holdsLock(this.mutex);
    }

    private boolean assertInactiveWithNoKnownPeers() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        assert (!this.active);
        assert (this.peersByAddress.isEmpty()) : this.peersByAddress.keySet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeersResponse handlePeersRequest(PeersRequest peersRequest) {
        Object object = this.mutex;
        synchronized (object) {
            List<DiscoveryNode> knownPeers;
            assert (!peersRequest.getSourceNode().equals(this.getLocalNode()));
            if (this.active) {
                assert (!this.leader.isPresent()) : this.leader;
                if (peersRequest.getSourceNode().isMasterEligibleNode()) {
                    this.startProbe(peersRequest.getSourceNode().getAddress());
                }
                peersRequest.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(this::startProbe);
                knownPeers = this.getFoundPeersUnderLock();
            } else {
                assert (this.leader.isPresent() || this.lastAcceptedNodes == null);
                knownPeers = Collections.emptyList();
            }
            return new PeersResponse(this.leader, knownPeers, this.currentTerm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<DiscoveryNode> getLeader() {
        Object object = this.mutex;
        synchronized (object) {
            return this.leader;
        }
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    private DiscoveryNode getLocalNode() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        return localNode;
    }

    protected abstract void onActiveMasterFound(DiscoveryNode var1, long var2);

    protected abstract void onFoundPeersUpdated();

    public List<TransportAddress> getLastResolvedAddresses() {
        return this.lastResolvedAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DiscoveryNode> getFoundPeers() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getFoundPeersUnderLock();
        }
    }

    private List<DiscoveryNode> getFoundPeersUnderLock() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        return this.peersByAddress.values().stream().map(Peer::getDiscoveryNode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private Peer createConnectingPeer(TransportAddress transportAddress) {
        Peer peer = new Peer(transportAddress);
        peer.establishConnection();
        return peer;
    }

    private boolean handleWakeUp() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        boolean peersRemoved = this.peersByAddress.values().removeIf(Peer::handleWakeUp);
        if (!this.active) {
            LOGGER.trace("not active");
            return peersRemoved;
        }
        LOGGER.trace("probing master nodes from cluster state: {}", (Object)this.lastAcceptedNodes);
        for (ObjectCursor discoveryNodeObjectCursor : this.lastAcceptedNodes.getMasterNodes().values()) {
            this.startProbe(((DiscoveryNode)discoveryNodeObjectCursor.value).getAddress());
        }
        this.configuredHostsResolver.resolveConfiguredHosts(providedAddresses -> {
            Object object = this.mutex;
            synchronized (object) {
                this.lastResolvedAddresses = providedAddresses;
                LOGGER.trace("probing resolved transport addresses {}", providedAddresses);
                providedAddresses.forEach(this::startProbe);
            }
        });
        this.transportService.getThreadPool().scheduleUnlessShuttingDown(this.findPeersInterval, "generic", new RejectableRunnable(){

            @Override
            public boolean isForceExecution() {
                return true;
            }

            @Override
            public void onFailure(Exception e) {
                assert (false) : e;
                LOGGER.debug("unexpected exception in wakeup", (Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRun() {
                Object object = PeerFinder.this.mutex;
                synchronized (object) {
                    if (!PeerFinder.this.handleWakeUp()) {
                        return;
                    }
                }
                PeerFinder.this.onFoundPeersUpdated();
            }

            public String toString() {
                return "PeerFinder handling wakeup";
            }
        });
        return peersRemoved;
    }

    protected void startProbe(TransportAddress transportAddress) {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        if (!this.active) {
            LOGGER.trace("startProbe({}) not running", (Object)transportAddress);
            return;
        }
        if (transportAddress.equals(this.getLocalNode().getAddress())) {
            LOGGER.trace("startProbe({}) not probing local node", (Object)transportAddress);
            return;
        }
        this.peersByAddress.computeIfAbsent(transportAddress, this::createConnectingPeer);
    }

    public static interface TransportAddressConnector {
        public void connectToRemoteMasterNode(TransportAddress var1, ActionListener<DiscoveryNode> var2);
    }

    public static interface ConfiguredHostsResolver {
        public void resolveConfiguredHosts(Consumer<List<TransportAddress>> var1);
    }

    private class Peer {
        private final TransportAddress transportAddress;
        private SetOnce<DiscoveryNode> discoveryNode = new SetOnce();
        private volatile boolean peersRequestInFlight;

        Peer(TransportAddress transportAddress) {
            this.transportAddress = transportAddress;
        }

        @Nullable
        DiscoveryNode getDiscoveryNode() {
            return (DiscoveryNode)this.discoveryNode.get();
        }

        boolean handleWakeUp() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            if (!PeerFinder.this.active) {
                return true;
            }
            DiscoveryNode discoveryNode = this.getDiscoveryNode();
            if (discoveryNode != null) {
                if (PeerFinder.this.transportService.nodeConnected(discoveryNode)) {
                    if (!this.peersRequestInFlight) {
                        this.requestPeers();
                    }
                } else {
                    LOGGER.trace("{} no longer connected", (Object)this);
                    return true;
                }
            }
            return false;
        }

        void establishConnection() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (this.getDiscoveryNode() == null) : "unexpectedly connected to " + String.valueOf(this.getDiscoveryNode());
            assert (PeerFinder.this.active);
            LOGGER.trace("{} attempting connection", (Object)this);
            PeerFinder.this.transportAddressConnector.connectToRemoteMasterNode(this.transportAddress, new ActionListener<DiscoveryNode>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(DiscoveryNode remoteNode) {
                    assert (remoteNode.isMasterEligibleNode()) : String.valueOf(remoteNode) + " is not master-eligible";
                    assert (!remoteNode.equals(PeerFinder.this.getLocalNode())) : String.valueOf(remoteNode) + " is the local node";
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        if (!PeerFinder.this.active) {
                            return;
                        }
                        assert (Peer.this.discoveryNode.get() == null) : "discoveryNode unexpectedly already set to " + String.valueOf(Peer.this.discoveryNode.get());
                        Peer.this.discoveryNode.set((Object)remoteNode);
                        Peer.this.requestPeers();
                    }
                    assert (!PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                    PeerFinder.this.onFoundPeersUpdated();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    LOGGER.debug(() -> new ParameterizedMessage("{} connection failed", (Object)Peer.this), (Throwable)e);
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        PeerFinder.this.peersByAddress.remove(Peer.this.transportAddress);
                    }
                }
            });
        }

        private void requestPeers() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (!this.peersRequestInFlight) : "PeersRequest already in flight";
            assert (PeerFinder.this.active);
            final DiscoveryNode discoveryNode = this.getDiscoveryNode();
            assert (discoveryNode != null) : "cannot request peers without first connecting";
            if (discoveryNode.equals(PeerFinder.this.getLocalNode())) {
                LOGGER.trace("{} not requesting peers from local node", (Object)this);
                return;
            }
            LOGGER.trace("{} requesting peers", (Object)this);
            this.peersRequestInFlight = true;
            List<DiscoveryNode> knownNodes = PeerFinder.this.getFoundPeersUnderLock();
            TransportResponseHandler<PeersResponse> peersResponseHandler = new TransportResponseHandler<PeersResponse>(){
                final /* synthetic */ Peer this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public PeersResponse read(StreamInput in) throws IOException {
                    return new PeersResponse(in);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResponse(PeersResponse response) {
                    LOGGER.trace("{} received {}", (Object)this.this$1, (Object)response);
                    Object object = this.this$1.PeerFinder.this.mutex;
                    synchronized (object) {
                        if (!this.this$1.PeerFinder.this.active) {
                            return;
                        }
                        this.this$1.peersRequestInFlight = false;
                        response.getMasterNode().map(DiscoveryNode::getAddress).ifPresent(this.this$1.PeerFinder.this::startProbe);
                        response.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(this.this$1.PeerFinder.this::startProbe);
                    }
                    if (response.getMasterNode().equals(Optional.of(discoveryNode))) {
                        assert (!this.this$1.PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                        this.this$1.PeerFinder.this.onActiveMasterFound(discoveryNode, response.getTerm());
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    this.this$1.peersRequestInFlight = false;
                    LOGGER.debug((Message)new ParameterizedMessage("{} peers request failed", (Object)this.this$1), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "generic";
                }
            };
            PeerFinder.this.transportService.sendRequest(discoveryNode, PeerFinder.REQUEST_PEERS_ACTION_NAME, (TransportRequest)new PeersRequest(PeerFinder.this.getLocalNode(), knownNodes), new TransportRequestOptions(PeerFinder.this.requestPeersTimeout), peersResponseHandler);
        }

        public String toString() {
            return "Peer{transportAddress=" + String.valueOf(this.transportAddress) + ", discoveryNode=" + String.valueOf(this.discoveryNode.get()) + ", peersRequestInFlight=" + this.peersRequestInFlight + "}";
        }
    }
}

