/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import io.crate.lucene.BlendedTermQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.match.ParsedOptions;
import io.crate.metadata.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.MultiMatchQueryType;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private QueryBuilder queryBuilder;

    public MultiMatchQuery(LuceneQueryBuilder.Context context, ParsedOptions parsedOptions) {
        super(context, parsedOptions);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch, Float boostValue) {
        Query query = this.parse(type, fieldName, value);
        if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) != null && boostValue != null && boostValue.floatValue() != 1.0f && !(query instanceof MatchNoDocsQuery)) {
            query = new BoostQuery(query, boostValue.floatValue());
        }
        return query;
    }

    public Query parse(MultiMatchQueryType type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) {
        assert (fieldNames.size() > 1) : "Must have more than one fieldName if using MultiMatchQuery";
        Float groupTieBreaker = this.parsedOptions.tieBreaker();
        float tieBreaker = groupTieBreaker == null ? type.tieBreaker() : groupTieBreaker.floatValue();
        switch (type) {
            case PHRASE: 
            case PHRASE_PREFIX: 
            case BEST_FIELDS: 
            case MOST_FIELDS: {
                this.queryBuilder = new QueryBuilder(tieBreaker);
                break;
            }
            case CROSS_FIELDS: {
                this.queryBuilder = new CrossFieldsQueryBuilder(tieBreaker);
                break;
            }
            default: {
                throw new IllegalStateException("No such type: " + String.valueOf((Object)type));
            }
        }
        List<Query> queries = this.queryBuilder.buildGroupedQueries(type, fieldNames, value, minimumShouldMatch);
        return this.queryBuilder.combineGrouped(queries);
    }

    static Query blendTerm(LuceneQueryBuilder.Context context, BytesRef value, Float commonTermsCutoff, float tieBreaker, RefAndBoost ... blendedFields) {
        return MultiMatchQuery.blendTerms(context, new BytesRef[]{value}, commonTermsCutoff, tieBreaker, blendedFields);
    }

    static Query blendTerms(LuceneQueryBuilder.Context context, BytesRef[] values, Float commonTermsCutoff, float tieBreaker, RefAndBoost ... blendedFields) {
        ArrayList<Object> queries = new ArrayList<Object>();
        Term[] terms = new Term[blendedFields.length * values.length];
        float[] blendedBoost = new float[blendedFields.length * values.length];
        int i = 0;
        for (RefAndBoost ft : blendedFields) {
            for (BytesRef term : values) {
                TermQuery query;
                try {
                    query = new TermQuery(new Term(ft.ref.storageIdent(), term));
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (ElasticsearchParseException parseException) {
                    if (parseException.getCause() instanceof IllegalArgumentException) continue;
                    throw parseException;
                }
                float boost = ft.boost;
                while (query instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)query;
                    query = bq.getQuery();
                    boost *= bq.getBoost();
                }
                if (query.getClass() == TermQuery.class) {
                    terms[i] = query.getTerm();
                    blendedBoost[i] = boost;
                    ++i;
                    continue;
                }
                if (boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                    query = new BoostQuery((Query)query, boost);
                }
                queries.add(query);
            }
        }
        if (i > 0) {
            terms = Arrays.copyOf(terms, i);
            blendedBoost = Arrays.copyOf(blendedBoost, i);
            if (commonTermsCutoff != null) {
                queries.add((Object)BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, commonTermsCutoff.floatValue()));
            } else {
                queries.add((Object)BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, tieBreaker));
            }
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        return new DisjunctionMaxQuery(queries, 1.0f);
    }

    static Query blendPhrase(PhraseQuery query, float tiebreaker, RefAndBoost ... fields) {
        ArrayList<PhraseQuery> disjunctions = new ArrayList<PhraseQuery>();
        for (RefAndBoost field : fields) {
            int[] positions = query.getPositions();
            Term[] terms = query.getTerms();
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(new Term(field.ref.storageIdent(), terms[i].bytes()), positions[i]);
            }
            PhraseQuery q = builder.build();
            if (field.boost != 1.0f) {
                q = new BoostQuery((Query)q, field.boost);
            }
            disjunctions.add(q);
        }
        return new DisjunctionMaxQuery(disjunctions, tiebreaker);
    }

    @Override
    protected Query blendTermQuery(Term term, Reference ref) {
        assert (this.queryBuilder != null) : "Must have called parse";
        return this.queryBuilder.blendTerm(term, ref);
    }

    @Override
    protected Query blendTermsQuery(Term[] terms, Reference ref) {
        assert (this.queryBuilder != null) : "Must have called parse";
        return this.queryBuilder.blendTerms(terms, ref);
    }

    @Override
    protected Query blendPhraseQuery(PhraseQuery query, Reference ref) {
        assert (this.queryBuilder != null) : "Must have called parse";
        return this.queryBuilder.blendPhrase(query, ref);
    }

    public class QueryBuilder {
        protected final float tieBreaker;

        public QueryBuilder(float tieBreaker) {
            this.tieBreaker = tieBreaker;
        }

        public List<Query> buildGroupedQueries(MultiMatchQueryType type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String fieldName : fieldNames.keySet()) {
                Float boostValue = fieldNames.get(fieldName);
                Query query = this.parseGroup(type.matchQueryType(), fieldName, boostValue, value, minimumShouldMatch);
                if (query == null) continue;
                queries.add(query);
            }
            return queries;
        }

        public Query parseGroup(MatchQuery.Type type, String field, Float boostValue, Object value, String minimumShouldMatch) {
            return MultiMatchQuery.this.parseAndApply(type, field, value, minimumShouldMatch, boostValue);
        }

        private Query combineGrouped(List<? extends Query> groupQuery) {
            if (groupQuery == null || groupQuery.isEmpty()) {
                return MultiMatchQuery.this.zeroTermsQuery();
            }
            if (groupQuery.size() == 1) {
                return groupQuery.get(0);
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Query query : groupQuery) {
                queries.add(query);
            }
            return new DisjunctionMaxQuery(queries, this.tieBreaker);
        }

        public Query blendTerm(Term term, Reference ref) {
            return MultiMatchQuery.super.blendTermQuery(term, ref);
        }

        public Query blendTerms(Term[] terms, Reference ref) {
            return MultiMatchQuery.super.blendTermsQuery(terms, ref);
        }

        public Query blendPhrase(PhraseQuery query, Reference ref) {
            return MultiMatchQuery.super.blendPhraseQuery(query, ref);
        }
    }

    final class CrossFieldsQueryBuilder
    extends QueryBuilder {
        private RefAndBoost[] blendedFields;

        CrossFieldsQueryBuilder(float tiebreaker) {
            super(tiebreaker);
        }

        @Override
        public List<Query> buildGroupedQueries(MultiMatchQueryType type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) {
            HashMap groups = new HashMap();
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
                String name = entry.getKey();
                Reference reference = MultiMatchQuery.this.context.getRef(name);
                if (reference != null) {
                    Float boost;
                    Analyzer analyzer = MultiMatchQuery.this.getSafeAnalyzer(reference);
                    if (!groups.containsKey(analyzer)) {
                        groups.put(analyzer, new ArrayList());
                    }
                    boost = (boost = entry.getValue()) == null ? Float.valueOf(1.0f) : boost;
                    ((List)groups.get(analyzer)).add(new RefAndBoost(reference, boost.floatValue()));
                    continue;
                }
                queries.add((Query)new MatchNoDocsQuery("unknown field " + name));
            }
            for (List group : groups.values()) {
                if (group.size() > 1) {
                    this.blendedFields = new RefAndBoost[group.size()];
                    int i = 0;
                    for (RefAndBoost fieldAndFieldType : group) {
                        this.blendedFields[i++] = fieldAndFieldType;
                    }
                } else {
                    this.blendedFields = null;
                }
                String representativeField = ((RefAndBoost)group.get((int)0)).ref.storageIdent();
                Query q = this.parseGroup(type.matchQueryType(), representativeField, Float.valueOf(1.0f), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            return queries.isEmpty() ? null : queries;
        }

        @Override
        public Query blendTerms(Term[] terms, Reference ref) {
            if (this.blendedFields == null || this.blendedFields.length == 1) {
                return super.blendTerms(terms, ref);
            }
            BytesRef[] values = new BytesRef[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                values[i] = terms[i].bytes();
            }
            Float commonTermsCutoff = MultiMatchQuery.this.parsedOptions.commonTermsCutoff();
            return MultiMatchQuery.blendTerms(MultiMatchQuery.this.context, values, commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query blendTerm(Term term, Reference ref) {
            if (this.blendedFields == null) {
                return super.blendTerm(term, ref);
            }
            Float commonTermsCutoff = MultiMatchQuery.this.parsedOptions.commonTermsCutoff();
            return MultiMatchQuery.blendTerm(MultiMatchQuery.this.context, term.bytes(), commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query blendPhrase(PhraseQuery query, Reference ref) {
            if (this.blendedFields == null) {
                return super.blendPhrase(query, ref);
            }
            return MultiMatchQuery.blendPhrase(query, this.tieBreaker, this.blendedFields);
        }
    }

    record RefAndBoost(Reference ref, float boost) {
    }
}

