/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType("indices:admin/seq_no/global_checkpoint_sync");

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, Request::new, Request::new, "management");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        try {
            this.maybeSyncTranslog(indexShard);
            listener.onResponse(new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse()));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(Request request, IndexShard indexShard) throws Exception {
        this.maybeSyncTranslog(indexShard);
        return new TransportReplicationAction.ReplicaResult();
    }

    private void maybeSyncTranslog(IndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        public Request(ShardId shardId) {
            super(shardId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

