/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class SeqNoStats
implements Writeable {
    public static final String MAX_SEQ_NO = "max_seq_no";
    public static final String LOCAL_CHECKPOINT = "local_checkpoint";
    public static final String GLOBAL_CHECKPOINT = "global_checkpoint";
    private final long maxSeqNo;
    private final long localCheckpoint;
    private final long globalCheckpoint;

    public SeqNoStats(long maxSeqNo, long localCheckpoint, long globalCheckpoint) {
        assert (localCheckpoint <= maxSeqNo) : "local checkpoint [" + localCheckpoint + "] is above maximum seq no [" + maxSeqNo + "]";
        this.maxSeqNo = maxSeqNo;
        this.localCheckpoint = localCheckpoint;
        this.globalCheckpoint = globalCheckpoint;
    }

    public SeqNoStats(StreamInput in) throws IOException {
        this(in.readZLong(), in.readZLong(), in.readZLong());
    }

    public long getMaxSeqNo() {
        return this.maxSeqNo;
    }

    public long getLocalCheckpoint() {
        return this.localCheckpoint;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeZLong(this.maxSeqNo);
        out.writeZLong(this.localCheckpoint);
        out.writeZLong(this.globalCheckpoint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeqNoStats that = (SeqNoStats)o;
        return this.maxSeqNo == that.maxSeqNo && this.localCheckpoint == that.localCheckpoint && this.globalCheckpoint == that.globalCheckpoint;
    }

    public int hashCode() {
        return Objects.hash(this.maxSeqNo, this.localCheckpoint, this.globalCheckpoint);
    }

    public String toString() {
        return "SeqNoStats{maxSeqNo=" + this.maxSeqNo + ", localCheckpoint=" + this.localCheckpoint + ", globalCheckpoint=" + this.globalCheckpoint + "}";
    }
}

