/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import io.crate.common.io.IOUtils;
import io.crate.types.DataTypes;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.plugins.IndexStorePlugin;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> {
        switch (s) {
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, DataTypes.STRING, Setting.Property.IndexScope, Setting.Property.NodeScope);

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        String storeType = indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.getWithFallback(indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open((Path)location, (LockFactory)lockFactory);
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    return new HybridDirectory(lockFactory, mMapDirectory);
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                return new MMapDirectory(location, lockFactory);
            }
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + String.valueOf((Object)type) + "]"));
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap((Directory)directory);
        return unwrap instanceof HybridDirectory;
    }

    static final class HybridDirectory
    extends NIOFSDirectory {
        private final MMapDirectory delegate;

        HybridDirectory(LockFactory lockFactory, MMapDirectory delegate) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            this.delegate = delegate;
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (this.useDelegate(name)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), this.delegate});
        }

        boolean useDelegate(String name) {
            String extension;
            switch (extension = FileSwitchDirectory.getExtension((String)name)) {
                case "nvd": 
                case "dvd": 
                case "tim": 
                case "tip": 
                case "dim": 
                case "kdd": 
                case "kdi": 
                case "cfs": 
                case "doc": {
                    return true;
                }
            }
            return false;
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }
}

