/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.recovery.BlobRecoveryRequest;

public class BlobRecoveryStartTransferRequest
extends BlobRecoveryRequest {
    private static final AtomicLong TRANSFER_ID_GENERATOR = new AtomicLong();
    private final String path;
    private final BytesReference content;
    private final long size;
    private final long transferId;

    public BlobRecoveryStartTransferRequest(long recoveryId, String path, BytesArray content, long size) {
        super(recoveryId);
        this.path = path;
        this.content = content;
        this.size = size;
        this.transferId = TRANSFER_ID_GENERATOR.incrementAndGet();
    }

    public String path() {
        return this.path;
    }

    public BytesReference content() {
        return this.content;
    }

    public long size() {
        return this.size;
    }

    public long transferId() {
        return this.transferId;
    }

    public BlobRecoveryStartTransferRequest(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
        this.content = in.readBytesReference();
        this.size = in.readVLong();
        this.transferId = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.path);
        out.writeBytesReference(this.content);
        out.writeVLong(this.size);
        out.writeVLong(this.transferId);
    }
}

