/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;

public class RecoveryState
implements Writeable {
    private Stage stage;
    private final Index index;
    private final Translog translog;
    private final VerifyIndex verifyIndex;
    private final Timer timer;
    private final boolean primary;
    private RecoverySource recoverySource;
    private ShardId shardId;
    @Nullable
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;

    public RecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, @Nullable DiscoveryNode sourceNode) {
        assert (shardRouting.initializing()) : "only allow initializing shard routing to be recovered: " + String.valueOf(shardRouting);
        RecoverySource recoverySource = shardRouting.recoverySource();
        assert (recoverySource.getType() == RecoverySource.Type.PEER == (sourceNode != null)) : "peer recovery requires source node, recovery type: " + String.valueOf((Object)recoverySource.getType()) + " source node: " + String.valueOf(sourceNode);
        this.shardId = shardRouting.shardId();
        this.primary = shardRouting.primary();
        this.recoverySource = recoverySource;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.stage = Stage.INIT;
        this.timer = new Timer();
        this.timer.start();
        this.index = new Index();
        this.translog = new Translog();
        this.verifyIndex = new VerifyIndex();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public synchronized Stage getStage() {
        return this.stage;
    }

    private void validateAndSetStage(Stage expected, Stage next) {
        if (this.stage != expected) {
            assert (false) : "can't move recovery to stage [" + String.valueOf((Object)next) + "]. current stage: [" + String.valueOf((Object)this.stage) + "] (expected [" + String.valueOf((Object)expected) + "])";
            throw new IllegalStateException("can't move recovery to stage [" + String.valueOf((Object)next) + "]. current stage: [" + String.valueOf((Object)this.stage) + "] (expected [" + String.valueOf((Object)expected) + "])");
        }
        this.stage = next;
    }

    public synchronized void validateCurrentStage(Stage expected) {
        if (this.stage != expected) {
            assert (false) : "expected stage [" + String.valueOf((Object)expected) + "]; but current stage is [" + String.valueOf((Object)this.stage) + "]";
            throw new IllegalStateException("expected stage [" + String.valueOf((Object)expected) + "] but current stage is [" + String.valueOf((Object)this.stage) + "]");
        }
    }

    public synchronized RecoveryState setStage(Stage stage) {
        switch (stage.ordinal()) {
            case 0: {
                this.stage = Stage.INIT;
                this.getIndex().reset();
                this.getVerifyIndex().reset();
                this.getTranslog().reset();
                break;
            }
            case 1: {
                this.validateAndSetStage(Stage.INIT, stage);
                this.getIndex().start();
                break;
            }
            case 2: {
                this.validateAndSetStage(Stage.INDEX, stage);
                this.getIndex().stop();
                this.getVerifyIndex().start();
                break;
            }
            case 3: {
                this.validateAndSetStage(Stage.VERIFY_INDEX, stage);
                this.getVerifyIndex().stop();
                this.getTranslog().start();
                break;
            }
            case 4: {
                assert (this.getIndex().bytesStillToRecover() >= 0L) : "moving to stage FINALIZE without completing file details";
                this.validateAndSetStage(Stage.TRANSLOG, stage);
                this.getTranslog().stop();
                break;
            }
            case 5: {
                this.validateAndSetStage(Stage.FINALIZE, stage);
                this.getTimer().stop();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown RecoveryState.Stage [" + String.valueOf((Object)stage) + "]");
            }
        }
        return this;
    }

    public Index getIndex() {
        return this.index;
    }

    public VerifyIndex getVerifyIndex() {
        return this.verifyIndex;
    }

    public Translog getTranslog() {
        return this.translog;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public RecoverySource getRecoverySource() {
        return this.recoverySource;
    }

    @Nullable
    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public RecoveryState(StreamInput in) throws IOException {
        this.timer = new Timer(in);
        this.stage = Stage.fromId(in.readByte());
        this.shardId = new ShardId(in);
        this.recoverySource = RecoverySource.readFrom(in);
        this.targetNode = new DiscoveryNode(in);
        this.sourceNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.index = new Index(in);
        this.translog = new Translog(in);
        this.verifyIndex = new VerifyIndex(in);
        this.primary = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.timer.writeTo(out);
        out.writeByte(this.stage.id());
        this.shardId.writeTo(out);
        this.recoverySource.writeTo(out);
        this.targetNode.writeTo(out);
        out.writeOptionalWriteable(this.sourceNode);
        this.index.writeTo(out);
        this.translog.writeTo(out);
        this.verifyIndex.writeTo(out);
        out.writeBoolean(this.primary);
    }

    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage INIT = new Stage(0);
        public static final /* enum */ Stage INDEX = new Stage(1);
        public static final /* enum */ Stage VERIFY_INDEX = new Stage(2);
        public static final /* enum */ Stage TRANSLOG = new Stage(3);
        public static final /* enum */ Stage FINALIZE = new Stage(4);
        public static final /* enum */ Stage DONE = new Stage(5);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) {
            if (id < 0 || id >= STAGES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        private static /* synthetic */ Stage[] $values() {
            return new Stage[]{INIT, INDEX, VERIFY_INDEX, TRANSLOG, FINALIZE, DONE};
        }

        static {
            $VALUES = Stage.$values();
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }

    public static class Timer
    implements Writeable {
        protected long startTime;
        protected long startNanoTime;
        protected long time;
        protected long stopTime;

        public Timer() {
            this.startTime = 0L;
            this.startNanoTime = 0L;
            this.time = -1L;
            this.stopTime = 0L;
        }

        public synchronized void start() {
            assert (this.startTime == 0L) : "already started";
            this.startTime = System.currentTimeMillis();
            this.startNanoTime = System.nanoTime();
        }

        public synchronized long startTime() {
            return this.startTime;
        }

        public synchronized long time() {
            if (this.startNanoTime == 0L) {
                return 0L;
            }
            if (this.time >= 0L) {
                return this.time;
            }
            return Math.max(0L, TimeValue.nsecToMSec((long)(System.nanoTime() - this.startNanoTime)));
        }

        public synchronized void stop() {
            assert (this.stopTime == 0L) : "already stopped";
            this.stopTime = Math.max(System.currentTimeMillis(), this.startTime);
            this.time = TimeValue.nsecToMSec((long)(System.nanoTime() - this.startNanoTime));
            assert (this.time >= 0L);
        }

        public synchronized void reset() {
            this.startTime = 0L;
            this.startNanoTime = 0L;
            this.time = -1L;
            this.stopTime = 0L;
        }

        public long getStartNanoTime() {
            return this.startNanoTime;
        }

        public Timer(StreamInput in) throws IOException {
            this.startTime = in.readVLong();
            this.startNanoTime = in.readVLong();
            this.stopTime = in.readVLong();
            this.time = in.readVLong();
        }

        @Override
        public synchronized void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.startTime);
            out.writeVLong(this.startNanoTime);
            out.writeVLong(this.stopTime);
            out.writeVLong(this.time());
        }
    }

    public static class Index
    extends Timer
    implements Writeable {
        private final RecoveryFilesDetails fileDetails;
        public static final long UNKNOWN = -1L;
        private long sourceThrottlingInNanos = -1L;
        private long targetThrottleTimeInNanos = -1L;

        public Index() {
            this.fileDetails = new RecoveryFilesDetails();
        }

        public Index(StreamInput in) throws IOException {
            super(in);
            this.fileDetails = new RecoveryFilesDetails(in);
            this.sourceThrottlingInNanos = in.readLong();
            this.targetThrottleTimeInNanos = in.readLong();
        }

        @Override
        public synchronized void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.fileDetails.writeTo(out);
            out.writeLong(this.sourceThrottlingInNanos);
            out.writeLong(this.targetThrottleTimeInNanos);
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.fileDetails.clear();
            this.sourceThrottlingInNanos = -1L;
            this.targetThrottleTimeInNanos = -1L;
        }

        public synchronized void addFileDetail(String name, long length, boolean reused) {
            this.fileDetails.addFileDetails(name, length, reused);
        }

        public synchronized void setFileDetailsComplete() {
            this.fileDetails.setComplete();
        }

        public synchronized void addRecoveredBytesToFile(String name, long bytes) {
            this.fileDetails.addRecoveredBytesToFile(name, bytes);
        }

        public synchronized void addSourceThrottling(long timeInNanos) {
            this.sourceThrottlingInNanos = this.sourceThrottlingInNanos == -1L ? timeInNanos : (this.sourceThrottlingInNanos += timeInNanos);
        }

        public synchronized void addTargetThrottling(long timeInNanos) {
            this.targetThrottleTimeInNanos = this.targetThrottleTimeInNanos == -1L ? timeInNanos : (this.targetThrottleTimeInNanos += timeInNanos);
        }

        public synchronized TimeValue sourceThrottling() {
            return TimeValue.timeValueNanos((long)this.sourceThrottlingInNanos);
        }

        public synchronized TimeValue targetThrottling() {
            return TimeValue.timeValueNanos((long)this.targetThrottleTimeInNanos);
        }

        public synchronized int totalFileCount() {
            return this.fileDetails.size();
        }

        public synchronized int totalRecoverFiles() {
            int total = 0;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                ++total;
            }
            return total;
        }

        public synchronized int recoveredFileCount() {
            int count = 0;
            for (File file : this.fileDetails.values()) {
                if (!file.fullyRecovered()) continue;
                ++count;
            }
            return count;
        }

        public synchronized float recoveredFilesPercent() {
            int total = 0;
            int recovered = 0;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                ++total;
                if (!file.fullyRecovered()) continue;
                ++recovered;
            }
            if (total == 0 && this.fileDetails.size() == 0) {
                return 0.0f;
            }
            if (total == recovered) {
                return 100.0f;
            }
            return 100.0f * ((float)recovered / (float)total);
        }

        public RecoveryFilesDetails fileDetails() {
            return this.fileDetails;
        }

        public synchronized long totalBytes() {
            long total = 0L;
            for (File file : this.fileDetails.values()) {
                total += file.length();
            }
            return total;
        }

        public synchronized long recoveredBytes() {
            long recovered = 0L;
            for (File file : this.fileDetails.values()) {
                recovered += file.recovered();
            }
            return recovered;
        }

        public synchronized long bytesStillToRecover() {
            if (!this.fileDetails.isComplete()) {
                return -1L;
            }
            long total = 0L;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                total += file.length() - file.recovered();
            }
            return total;
        }

        public synchronized float recoveredBytesPercent() {
            long total = 0L;
            long recovered = 0L;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                total += file.length();
                recovered += file.recovered();
            }
            if (total == 0L && this.fileDetails.size() == 0) {
                return 0.0f;
            }
            if (total == recovered) {
                return 100.0f;
            }
            return 100.0f * (float)recovered / (float)total;
        }

        public synchronized int reusedFileCount() {
            int reused = 0;
            for (File file : this.fileDetails.values()) {
                if (!file.reused()) continue;
                ++reused;
            }
            return reused;
        }

        public synchronized long reusedBytes() {
            long reused = 0L;
            for (File file : this.fileDetails.values()) {
                if (!file.reused()) continue;
                reused += file.length();
            }
            return reused;
        }

        public File getFileDetails(String dest) {
            return this.fileDetails.get(dest);
        }
    }

    public static class Translog
    extends Timer
    implements Writeable {
        public static final int UNKNOWN = -1;
        private int recovered;
        private int total;
        private int totalOnStart;
        private int totalLocal = -1;

        public Translog() {
            this.total = -1;
            this.totalOnStart = -1;
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.recovered = 0;
            this.total = -1;
            this.totalOnStart = -1;
            this.totalLocal = -1;
        }

        public synchronized void incrementRecoveredOperations() {
            ++this.recovered;
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized void incrementRecoveredOperations(int ops) {
            this.recovered += ops;
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized int recoveredOperations() {
            return this.recovered;
        }

        public synchronized int totalOperationsOnStart() {
            return this.totalOnStart;
        }

        public synchronized int totalOperations() {
            return this.total;
        }

        public synchronized void totalOperations(int total) {
            int n = this.total = this.totalLocal == -1 ? total : this.totalLocal + total;
            assert (total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + total + "], recovered [" + this.recovered + "]";
        }

        public synchronized void totalOperationsOnStart(int total) {
            this.totalOnStart = this.totalLocal == -1 ? total : this.totalLocal + total;
        }

        public synchronized void totalLocal(int totalLocal) {
            assert (totalLocal >= this.recovered) : totalLocal + " < " + this.recovered;
            this.totalLocal = totalLocal;
        }

        public synchronized int totalLocal() {
            return this.totalLocal;
        }

        public synchronized float recoveredPercent() {
            if (this.total == -1) {
                return -1.0f;
            }
            if (this.total == 0) {
                return 100.0f;
            }
            return (float)this.recovered * 100.0f / (float)this.total;
        }

        public Translog(StreamInput in) throws IOException {
            super(in);
            this.recovered = in.readVInt();
            this.total = in.readVInt();
            this.totalOnStart = in.readVInt();
            if (in.getVersion().onOrAfter(Version.V_4_3_0)) {
                this.totalLocal = in.readVInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            Translog translog = this;
            synchronized (translog) {
                out.writeVInt(this.recovered);
                out.writeVInt(this.total);
                out.writeVInt(this.totalOnStart);
                if (out.getVersion().onOrAfter(Version.V_4_3_0)) {
                    out.writeVInt(this.totalLocal);
                }
            }
        }
    }

    public static class VerifyIndex
    extends Timer
    implements Writeable {
        private volatile long checkIndexTime;

        public VerifyIndex() {
            this.checkIndexTime = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.checkIndexTime = 0L;
        }

        public long checkIndexTime() {
            return this.checkIndexTime;
        }

        public void checkIndexTime(long checkIndexTime) {
            this.checkIndexTime = checkIndexTime;
        }

        public VerifyIndex(StreamInput in) throws IOException {
            super(in);
            this.checkIndexTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.checkIndexTime);
        }
    }

    public static class RecoveryFilesDetails
    implements Writeable {
        private final Map<String, File> fileDetails = new HashMap<String, File>();
        private boolean complete;

        RecoveryFilesDetails() {
        }

        RecoveryFilesDetails(StreamInput in) throws IOException {
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                File file = new File(in);
                this.fileDetails.put(file.name, file);
            }
            this.complete = in.getVersion().onOrAfter(Version.V_5_2_0) ? in.readBoolean() : !this.fileDetails.isEmpty();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            File[] files = this.values().toArray(new File[0]);
            out.writeVInt(files.length);
            for (File file : files) {
                file.writeTo(out);
            }
            if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
                out.writeBoolean(this.complete);
            }
        }

        public void addFileDetails(String name, long length, boolean reused) {
            assert (!this.complete) : "addFileDetail for [" + name + "] when file details are already complete";
            File existing = this.fileDetails.put(name, new File(name, length, reused));
            assert (existing == null) : "file [" + name + "] is already reported";
        }

        public void addRecoveredBytesToFile(String name, long bytes) {
            File file = this.fileDetails.get(name);
            assert (file != null) : "file [" + name + "] hasn't been reported";
            file.addRecoveredBytes(bytes);
        }

        public File get(String name) {
            return this.fileDetails.get(name);
        }

        public void setComplete() {
            this.complete = true;
        }

        public int size() {
            return this.fileDetails.size();
        }

        public boolean isEmpty() {
            return this.fileDetails.isEmpty();
        }

        public void clear() {
            this.fileDetails.clear();
            this.complete = false;
        }

        public Collection<File> values() {
            return this.fileDetails.values();
        }

        public boolean isComplete() {
            return this.complete;
        }
    }

    public static class File
    implements Writeable {
        private final String name;
        private final long length;
        private final boolean reused;
        private long recovered;

        public File(String name, long length, boolean reused) {
            assert (name != null);
            this.name = name;
            this.length = length;
            this.reused = reused;
        }

        void addRecoveredBytes(long bytes) {
            assert (!this.reused) : "file is marked as reused, can't update recovered bytes";
            assert (bytes >= 0L) : "can't recovered negative bytes. got [" + bytes + "]";
            this.recovered += bytes;
        }

        public String name() {
            return this.name;
        }

        public long length() {
            return this.length;
        }

        public long recovered() {
            return this.recovered;
        }

        public boolean reused() {
            return this.reused;
        }

        boolean fullyRecovered() {
            return !this.reused && this.length == this.recovered;
        }

        public File(StreamInput in) throws IOException {
            this.name = in.readString();
            this.length = in.readVLong();
            this.recovered = in.readVLong();
            this.reused = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.length);
            out.writeVLong(this.recovered);
            out.writeBoolean(this.reused);
        }

        public boolean equals(Object obj) {
            if (obj instanceof File) {
                File other = (File)obj;
                return this.name.equals(other.name) && this.length == other.length() && this.reused == other.reused() && this.recovered == other.recovered();
            }
            return false;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Long.hashCode(this.length);
            result = 31 * result + Long.hashCode(this.recovered);
            result = 31 * result + (this.reused ? 1 : 0);
            return result;
        }

        public String toString() {
            return "file (name [" + this.name + "], reused [" + this.reused + "], length [" + this.length + "], recovered [" + this.recovered + "])";
        }
    }
}

