/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import io.crate.analyze.Analyzer;
import io.crate.analyze.NumberOfShards;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.auth.AlwaysOKAuthentication;
import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.HostBasedAuthentication;
import io.crate.blob.BlobService;
import io.crate.blob.BlobTransferTarget;
import io.crate.blob.transfer.BlobHeadRequestHandler;
import io.crate.blob.v2.BlobIndicesModule;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.cluster.gracefulstop.DecommissioningService;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.execution.TransportExecutorModule;
import io.crate.execution.ddl.RepositoryService;
import io.crate.execution.ddl.tables.CreateTableClient;
import io.crate.execution.engine.collect.CollectOperationModule;
import io.crate.execution.engine.collect.files.CopyModule;
import io.crate.execution.engine.collect.stats.JobsLogService;
import io.crate.execution.jobs.JobModule;
import io.crate.execution.jobs.TasksService;
import io.crate.expression.reference.sys.check.SysChecksModule;
import io.crate.expression.reference.sys.check.node.SysNodeChecksModule;
import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.DanglingArtifactsService;
import io.crate.metadata.Functions;
import io.crate.metadata.MetadataModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.blob.BlobSchemaInfo;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.information.InformationSchemaInfo;
import io.crate.metadata.information.MetadataInformationModule;
import io.crate.metadata.pgcatalog.PgCatalogSchemaInfo;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.metadata.sys.MetadataSysModule;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.module.CrateCommonModule;
import io.crate.monitor.MonitorModule;
import io.crate.netty.NettyBootstrap;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Planner;
import io.crate.planner.optimizer.LoadedRules;
import io.crate.plugin.CopyPlugin;
import io.crate.protocols.postgres.PgClientFactory;
import io.crate.protocols.postgres.PostgresNetty;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.protocols.ssl.SslContextProviderService;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.ShardReplicationService;
import io.crate.role.RoleManager;
import io.crate.role.RoleManagerService;
import io.crate.role.Roles;
import io.crate.role.RolesService;
import io.crate.session.Sessions;
import io.crate.statistics.TableStats;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.udc.service.UDCService;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Assertions;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.BatchedRerouteService;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.NodeAndClusterIdStateListener;
import org.elasticsearch.common.network.DnsResolver;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.fs.FsHealthService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.snapshots.InternalSnapshotsInfoService;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusters;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.jetbrains.annotations.Nullable;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting("node.data", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting("node.master", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, (DataType<?>)DataTypes.STRING, Setting.Property.NodeScope));
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.timeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;

    public Node(Environment environment) {
        this(environment, Collections.emptyList());
    }

    public Node(Environment environment, Collection<Class<? extends Plugin>> classpathPlugins) {
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        boolean success = false;
        try {
            Settings tmpSettings = Settings.builder().put(environment.settings()).build();
            this.nodeEnvironment = new NodeEnvironment(tmpSettings, environment);
            resourcesToClose.add(this.nodeEnvironment);
            this.logger.info("node name [{}], node ID [{}], cluster name [{}]", (Object)NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings).value());
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            this.logVersion(this.logger, jvmInfo);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)environment.configFile(), (Object)Arrays.toString(environment.dataFiles()), (Object)environment.logsFile(), (Object)environment.pluginsFile());
            }
            this.pluginsService = new PluginsService(tmpSettings, environment.configFile(), environment.pluginsFile(), classpathPlugins);
            this.settings = this.pluginsService.updatedSettings();
            SessionSettingRegistry sessionSettingRegistry = new SessionSettingRegistry(Set.of(LoadedRules.INSTANCE));
            Functions functions = Functions.load(this.settings, sessionSettingRegistry, this.pluginsService.classLoaders().toArray(new ClassLoader[0]));
            Set<DiscoveryNodeRole> possibleRoles = Stream.concat(DiscoveryNodeRole.BUILT_IN_ROLES.stream(), this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getRoles).flatMap(Collection::stream)).collect(Collectors.toSet());
            DiscoveryNode.setPossibleRoles(possibleRoles);
            this.localNodeFactory = new LocalNodeFactory(this.settings, this.nodeEnvironment.nodeId());
            this.environment = new Environment(this.settings, environment.configFile());
            Environment.assertEquivalent(environment, this.environment);
            ThreadPool threadPool = new ThreadPool(this.settings);
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ArrayList additionalSettings = new ArrayList(this.pluginsService.getPluginSettings());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient();
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            Set<SettingUpgrader<?>> settingsUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getSettingUpgraders).flatMap(Collection::stream).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(this.settings, additionalSettings, settingsUpgraders);
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            ClusterService clusterService = new ClusterService(this.settings, settingsModule.getClusterSettings(), threadPool);
            resourcesToClose.add(clusterService);
            RolesService roles = new RolesService(clusterService);
            TableStats tableStats = new TableStats();
            NodeContext nodeContext = NodeContext.of(environment, clusterService, functions, roles, tableStats);
            UserDefinedFunctionService udfService = new UserDefinedFunctionService(clusterService, nodeContext);
            SetOnce rerouteServiceReference = new SetOnce();
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(this.settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool::relativeTimeInMillis, () -> ((SetOnce)rerouteServiceReference).get());
            SetOnce repositoriesServiceReference = new SetOnce();
            ClusterInfoService clusterInfoService = this.newClusterInfoService(this.settings, clusterService, threadPool, this.client);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(new Module[]{pluginModule});
            }
            if (NODE_DATA_SETTING.get(this.settings).booleanValue()) {
                modules.add(new Module[]{new BlobIndicesModule()});
            }
            modules.add(new Module[]{new CrateCommonModule()});
            modules.add(new Module[]{new TransportExecutorModule()});
            modules.add(new Module[]{new JobModule()});
            modules.add(new Module[]{new CollectOperationModule()});
            modules.add(new Module[]{new MetadataModule()});
            modules.add(new Module[]{new MetadataSysModule()});
            modules.add(new Module[]{new MetadataInformationModule()});
            modules.add(new Module[]{new MonitorModule()});
            modules.add(new Module[]{new SysChecksModule()});
            modules.add(new Module[]{new SysNodeChecksModule()});
            MonitorService monitorService = new MonitorService(this.settings, this.nodeEnvironment, threadPool);
            InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(this.settings, clusterService, () -> ((SetOnce)repositoriesServiceReference).get(), () -> ((SetOnce)rerouteServiceReference).get());
            ClusterModule clusterModule = new ClusterModule(this.settings, clusterService, clusterPlugins, clusterInfoService, snapshotsInfoService);
            FsHealthService fsHealthService = new FsHealthService(this.settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment);
            modules.add(new Module[]{clusterModule});
            IndicesModule indicesModule = new IndicesModule();
            modules.add(new Module[]{indicesModule});
            IndexSearcher.setMaxClauseCount((int)LuceneQueryBuilder.INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
            HierarchyCircuitBreakerService circuitBreakerService = new HierarchyCircuitBreakerService(this.settings, settingsModule.getClusterSettings());
            resourcesToClose.add(circuitBreakerService);
            modules.add(new Module[]{new GatewayModule()});
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(this.settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            modules.add(new Module[]{settingsModule});
            List<NamedWriteableRegistry.Entry> namedWriteables = Stream.of(IndicesModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream(), MetadataModule.getNamedWriteables().stream()).flatMap(Function.identity()).toList();
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(IndicesModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream(), MetadataModule.getNamedXContents(nodeContext).stream()).flatMap(Function.identity()).toList());
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, namedWriteableRegistry, xContentRegistry);
            PersistedClusterStateService persistedClusterStateService = new PersistedClusterStateService(this.nodeEnvironment, xContentRegistry, namedWriteableRegistry, bigArrays, clusterService.getClusterSettings(), threadPool::relativeTimeInMillis);
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            List<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders = Stream.concat(indicesModule.getEngineFactories().stream(), enginePlugins.stream().map(plugin -> plugin::getEngineFactory)).toList();
            Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
            IndicesService indicesService = new IndicesService(nodeContext, this.settings, clusterService, this.pluginsService, this.nodeEnvironment, analysisModule.getAnalysisRegistry(), threadPool, indexScopedSettings, circuitBreakerService, bigArrays, metaStateService, engineFactoryProviders, indexStoreFactories);
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(this.settings, clusterService);
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(nodeContext, clusterService, indicesService, clusterModule.getAllocationService(), shardLimitValidator, environment, indexScopedSettings);
            List pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, xContentRegistry, environment, this.nodeEnvironment, namedWriteableRegistry, () -> ((SetOnce)repositoriesServiceReference).get()).stream()).toList();
            modules.add(new Module[]{new ActionModule()});
            Authentication authentication = AuthSettings.AUTH_HOST_BASED_ENABLED_SETTING.get(this.settings) != false ? new HostBasedAuthentication(this.settings, roles, DnsResolver.SYSTEM, () -> clusterService.state().metadata().clusterUUID()) : new AlwaysOKAuthentication(roles);
            SslContextProvider sslContextProvider = new SslContextProvider(this.settings);
            NettyBootstrap nettyBootstrap = new NettyBootstrap(this.settings);
            nettyBootstrap.start();
            MetadataUpgradeService metadataIndexUpgradeService = new MetadataUpgradeService(nodeContext, indexScopedSettings, udfService);
            Netty4Transport transport = new Netty4Transport(this.settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, nettyBootstrap, authentication, sslContextProvider);
            TransportService transportService = this.newTransportService(this.settings, transport, threadPool, this.localNodeFactory, settingsModule.getClusterSettings());
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            BlobIndicesService blobIndicesService = new BlobIndicesService(this.settings, clusterService);
            BlobTransferTarget blobTransferTarget = new BlobTransferTarget(blobIndicesService, threadPool, transportService, clusterService);
            BlobService blobService = new BlobService(clusterService, blobIndicesService, new BlobHeadRequestHandler(transportService, clusterService, blobTransferTarget, threadPool), this.client);
            PgClientFactory pgClientFactory = this.newPgClientFactory(this.settings, transportService, transport, sslContextProvider, pageCacheRecycler, nettyBootstrap);
            RemoteClusters remoteClusters = new RemoteClusters(this.settings, threadPool, pgClientFactory, transportService);
            resourcesToClose.add(remoteClusters);
            LogicalReplicationSettings logicalReplicationSettings = new LogicalReplicationSettings(this.settings, clusterService);
            LogicalReplicationService logicalReplicationService = new LogicalReplicationService(this.settings, indexScopedSettings, clusterService, remoteClusters, threadPool, this.client, clusterModule.getAllocationService(), metadataIndexUpgradeService, logicalReplicationSettings);
            resourcesToClose.add(logicalReplicationService);
            LogicalReplicationSettings replicationSettings = new LogicalReplicationSettings(this.settings, clusterService);
            RecoverySettings recoverySettings = new RecoverySettings(this.settings, settingsModule.getClusterSettings());
            RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), transportService, clusterService, logicalReplicationService, metadataIndexUpgradeService, remoteClusters, threadPool, namedWriteableRegistry, xContentRegistry, replicationSettings, recoverySettings);
            modules.add(new Module[]{repositoriesModule});
            CopyModule copyModule = new CopyModule(this.pluginsService.filterPlugins(CopyPlugin.class));
            modules.add(new Module[]{copyModule});
            RepositoriesService repositoriesService = repositoriesModule.repositoryService();
            repositoriesServiceReference.set((Object)repositoriesService);
            logicalReplicationService.repositoriesService(repositoriesService);
            SnapshotsService snapshotsService = new SnapshotsService(this.settings, clusterService, repositoriesService, transportService);
            SnapshotShardsService snapshotShardsService = new SnapshotShardsService(this.settings, clusterService, repositoriesService, transportService, indicesService);
            RestoreService restoreService = new RestoreService(clusterService, repositoriesService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, clusterService.getClusterSettings(), shardLimitValidator);
            logicalReplicationService.restoreService(restoreService);
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            rerouteServiceReference.set((Object)rerouteService);
            DiscoveryModule discoveryModule = new DiscoveryModule(this.settings, transportService, namedWriteableRegistry, networkService, clusterService.getMasterService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), environment.configFile(), gatewayMetaState, rerouteService, fsHealthService, metadataIndexUpgradeService);
            this.nodeService = new NodeService(monitorService, indicesService, transportService);
            DDLClusterStateService ddlClusterStateService = new DDLClusterStateService();
            RoleManagerService rolesManager = new RoleManagerService(this.client, roles, ddlClusterStateService);
            AnalysisRegistry analysisRegistry = analysisModule.getAnalysisRegistry();
            AtomicReference<Injector> injectorRef = new AtomicReference<Injector>();
            Provider dependencyCarrier = () -> (DependencyCarrier)((Injector)injectorRef.get()).getInstance(DependencyCarrier.class);
            Planner planner = new Planner(this.settings, clusterService, nodeContext, tableStats, new NumberOfShards(clusterService), new CreateTableClient(this.client), rolesManager, new ForeignDataWrappers(this.settings, clusterService, nodeContext), sessionSettingRegistry);
            RepositoryService repositoryService = new RepositoryService(clusterService, this.client);
            Analyzer analyzer = new Analyzer(nodeContext, new RelationAnalyzer(nodeContext), clusterService, analysisRegistry, repositoryService, roles, sessionSettingRegistry, logicalReplicationService);
            JobsLogService jobsLogService = new JobsLogService(this.settings, clusterService, nodeContext, circuitBreakerService);
            Sessions sessions = new Sessions(nodeContext, analyzer, planner, (Provider<DependencyCarrier>)dependencyCarrier, jobsLogService.get(), this.settings, clusterService, sessionSettingRegistry);
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkService, bigArrays, threadPool, xContentRegistry, sslContextProvider, blobService, sessions, authentication, roles, circuitBreakerService, this.client);
            modules.add(new Module[]{b -> {
                b.bind(Node.class).toInstance((Object)this);
                b.bind(NodeContext.class).toInstance((Object)nodeContext);
                b.bind(TableStats.class).toInstance((Object)tableStats);
                b.bind(Analyzer.class).toInstance((Object)analyzer);
                b.bind(Sessions.class).toInstance((Object)sessions);
                b.bind(Planner.class).toInstance((Object)planner);
                b.bind(JobsLogService.class).toInstance((Object)jobsLogService);
                b.bind(RepositoryService.class).toInstance((Object)repositoryService);
                b.bind(RoleManager.class).toInstance((Object)rolesManager);
                b.bind(DDLClusterStateService.class).toInstance((Object)ddlClusterStateService);
                b.bind(NodeService.class).toInstance((Object)this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance((Object)xContentRegistry);
                b.bind(PluginsService.class).toInstance((Object)this.pluginsService);
                b.bind(Client.class).toInstance((Object)this.client);
                b.bind(NodeClient.class).toInstance((Object)this.client);
                b.bind(Environment.class).toInstance((Object)this.environment);
                b.bind(ThreadPool.class).toInstance((Object)threadPool);
                b.bind(NodeEnvironment.class).toInstance((Object)this.nodeEnvironment);
                b.bind(CircuitBreakerService.class).toInstance((Object)circuitBreakerService);
                b.bind(BigArrays.class).toInstance((Object)bigArrays);
                b.bind(PageCacheRecycler.class).toInstance((Object)pageCacheRecycler);
                b.bind(AnalysisRegistry.class).toInstance((Object)analysisRegistry);
                b.bind(NamedWriteableRegistry.class).toInstance((Object)namedWriteableRegistry);
                b.bind(MetaStateService.class).toInstance((Object)metaStateService);
                b.bind(PersistedClusterStateService.class).toInstance((Object)persistedClusterStateService);
                b.bind(IndicesService.class).toInstance((Object)indicesService);
                b.bind(MetadataCreateIndexService.class).toInstance((Object)metadataCreateIndexService);
                b.bind(Transport.class).toInstance((Object)transport);
                b.bind(Netty4Transport.class).toInstance((Object)transport);
                b.bind(TransportService.class).toInstance((Object)transportService);
                b.bind(NetworkService.class).toInstance((Object)networkService);
                b.bind(MetadataUpgradeService.class).toInstance((Object)metadataIndexUpgradeService);
                b.bind(ClusterInfoService.class).toInstance((Object)clusterInfoService);
                b.bind(SnapshotsInfoService.class).toInstance((Object)snapshotsInfoService);
                b.bind(GatewayMetaState.class).toInstance((Object)gatewayMetaState);
                b.bind(RepositoriesService.class).toInstance((Object)repositoriesService);
                b.bind(SnapshotsService.class).toInstance((Object)snapshotsService);
                b.bind(SnapshotShardsService.class).toInstance((Object)snapshotShardsService);
                b.bind(RestoreService.class).toInstance((Object)restoreService);
                b.bind(BlobService.class).toInstance((Object)blobService);
                b.bind(BlobIndicesService.class).toInstance((Object)blobIndicesService);
                b.bind(BlobTransferTarget.class).toInstance((Object)blobTransferTarget);
                b.bind(Coordinator.class).toInstance((Object)discoveryModule.getCoordinator());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                b.bind(PeerRecoverySourceService.class).toInstance((Object)new PeerRecoverySourceService(transportService, indicesService, clusterService, recoverySettings, blobTransferTarget, blobIndicesService));
                b.bind(PeerRecoveryTargetService.class).toInstance((Object)new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService));
                b.bind(HttpServerTransport.class).toInstance((Object)httpServerTransport);
                b.bind(ShardLimitValidator.class).toInstance((Object)shardLimitValidator);
                b.bind(NettyBootstrap.class).toInstance((Object)nettyBootstrap);
                b.bind(SslContextProvider.class).toInstance((Object)sslContextProvider);
                b.bind(RerouteService.class).toInstance((Object)rerouteService);
                b.bind(Roles.class).toInstance((Object)roles);
                b.bind(Authentication.class).toInstance((Object)authentication);
                b.bind(LogicalReplicationService.class).toInstance((Object)logicalReplicationService);
                b.bind(LogicalReplicationSettings.class).toInstance((Object)logicalReplicationSettings);
                b.bind(RemoteClusters.class).toInstance((Object)remoteClusters);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
                b.bind(FsHealthService.class).toInstance((Object)fsHealthService);
                b.bind(SessionSettingRegistry.class).toInstance((Object)sessionSettingRegistry);
                b.bind(Functions.class).toInstance((Object)functions);
                b.bind(UserDefinedFunctionService.class).toInstance((Object)udfService);
                Schemas schemas = nodeContext.schemas();
                b.bind(SysSchemaInfo.class).toInstance((Object)((SysSchemaInfo)schemas.getSystemSchema("sys")));
                b.bind(PgCatalogSchemaInfo.class).toInstance((Object)((PgCatalogSchemaInfo)schemas.getSystemSchema("pg_catalog")));
                b.bind(InformationSchemaInfo.class).toInstance((Object)((InformationSchemaInfo)schemas.getSystemSchema("information_schema")));
                b.bind(BlobSchemaInfo.class).toInstance((Object)((BlobSchemaInfo)schemas.getSystemSchema("blob")));
            }});
            this.injector = modules.createInjector();
            injectorRef.set(this.injector);
            clusterModule.setExistingShardsAllocators((GatewayAllocator)this.injector.getInstance(GatewayAllocator.class));
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(arg_0 -> ((Injector)this.injector).getInstance(arg_0)).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add((Closeable)this.injector.getInstance(PeerRecoverySourceService.class));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            this.client.initialize((Map)this.injector.getInstance((Key)new Key<Map<ActionType, TransportAction>>(this){}));
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    protected PgClientFactory newPgClientFactory(Settings settings, TransportService transportService, Netty4Transport transport, SslContextProvider sslContextProvider, PageCacheRecycler pageCacheRecycler, NettyBootstrap nettyBootstrap) {
        return new PgClientFactory(settings, transportService, transport, sslContextProvider, pageCacheRecycler, nettyBootstrap);
    }

    private void logVersion(Logger logger, JvmInfo jvmInfo) {
        logger.info("version[{}], pid[{}], build[{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}]", (Object)Version.displayVersion(Version.CURRENT, Version.CURRENT.isSnapshot()), (Object)jvmInfo.pid(), (Object)Build.CURRENT.hashShort(), (Object)Build.CURRENT.timestamp(), (Object)Constants.OS_NAME, (Object)Constants.OS_VERSION, (Object)Constants.OS_ARCH, (Object)Constants.JVM_VENDOR, (Object)Constants.JVM_NAME, (Object)Runtime.version());
        Node.warnIfPreRelease(Version.CURRENT, Version.CURRENT.isSnapshot(), logger);
    }

    private static void warnIfPreRelease(Version version, boolean isSnapshot, Logger logger) {
        if (!version.isRelease() || isSnapshot) {
            logger.warn("version [{}] is a pre-release version of CrateDB and is not suitable for production", (Object)Version.displayVersion(version, isSnapshot));
        }
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings) {
        return new TransportService(settings, transport, threadPool, localNodeFactory, clusterSettings);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.settings;
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Coordinator coordinator;
        ClusterService clusterService;
        block18: {
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            if (UDCService.UDC_ENABLED_SETTING.get(this.settings).booleanValue()) {
                ((UDCService)this.injector.getInstance(UDCService.class)).start();
            }
            ((BlobService)this.injector.getInstance(BlobService.class)).start();
            ((DecommissioningService)this.injector.getInstance(DecommissioningService.class)).start();
            ((JobsLogService)this.injector.getInstance(JobsLogService.class)).start();
            ((PostgresNetty)this.injector.getInstance(PostgresNetty.class)).start();
            ((TasksService)this.injector.getInstance(TasksService.class)).start();
            ((DanglingArtifactsService)this.injector.getInstance(DanglingArtifactsService.class)).start();
            ((SslContextProviderService)this.injector.getInstance(SslContextProviderService.class)).start();
            ((IndicesService)this.injector.getInstance(IndicesService.class)).start();
            ((IndicesClusterStateService)this.injector.getInstance(IndicesClusterStateService.class)).start();
            ((SnapshotsService)this.injector.getInstance(SnapshotsService.class)).start();
            ((SnapshotShardsService)this.injector.getInstance(SnapshotShardsService.class)).start();
            ((FsHealthService)this.injector.getInstance(FsHealthService.class)).start();
            ((RepositoriesService)this.injector.getInstance(RepositoriesService.class)).start();
            ((UserDefinedFunctionService)this.injector.getInstance(UserDefinedFunctionService.class)).start();
            this.nodeService.getMonitorService().start();
            clusterService = (ClusterService)this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = (NodeConnectionsService)this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            ((GatewayService)this.injector.getInstance(GatewayService.class)).start();
            coordinator = (Coordinator)this.injector.getInstance(Coordinator.class);
            clusterService.getMasterService().setClusterStatePublisher(coordinator);
            HttpServerTransport httpServerTransport = (HttpServerTransport)this.injector.getInstance(HttpServerTransport.class);
            httpServerTransport.start();
            TransportAddress publishAddress = httpServerTransport.boundAddress().publishAddress();
            this.localNodeFactory.httpPublishAddress = publishAddress.getAddress() + ":" + publishAddress.getPort();
            transportService = (TransportService)this.injector.getInstance(TransportService.class);
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            ((PeerRecoverySourceService)this.injector.getInstance(PeerRecoverySourceService.class)).start();
            gatewayMetaState = (GatewayMetaState)this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, (MetaStateService)this.injector.getInstance(MetaStateService.class), (MetadataUpgradeService)this.injector.getInstance(MetadataUpgradeService.class), (PersistedClusterStateService)this.injector.getInstance(PersistedClusterStateService.class));
            if (Assertions.ENABLED) {
                try {
                    assert (((Manifest)((MetaStateService)this.injector.getInstance(MetaStateService.class)).loadFullState().v1()).isEmpty());
                    NodeMetadata nodeMetadata = NodeMetadata.FORMAT.loadLatestState(this.logger, NamedWriteableRegistry.EMPTY, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals(Version.CURRENT));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).toList());
        coordinator.start();
        clusterService.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        coordinator.startInitialJoin();
        final TimeValue initialStateTimeout = INITIAL_STATE_TIMEOUT_SETTING.get(this.settings);
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService.getClusterApplierService(), null, this.logger);
            if (clusterState.nodes().getMasterNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){
                    final /* synthetic */ Node this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        this.this$0.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getMasterNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        if (WRITE_PORTS_FILE_SETTING.get(this.settings).booleanValue()) {
            TransportService transport = (TransportService)this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = (HttpServerTransport)this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
        }
        this.logger.info("started");
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(ClusterPlugin::onNodeStarted);
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService);
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        ((HttpServerTransport)this.injector.getInstance(HttpServerTransport.class)).stop();
        ((UserDefinedFunctionService)this.injector.getInstance(UserDefinedFunctionService.class)).stop();
        ((SnapshotsService)this.injector.getInstance(SnapshotsService.class)).stop();
        ((SnapshotShardsService)this.injector.getInstance(SnapshotShardsService.class)).stop();
        ((RepositoriesService)this.injector.getInstance(RepositoriesService.class)).stop();
        ((IndicesClusterStateService)this.injector.getInstance(IndicesClusterStateService.class)).stop();
        ((Coordinator)this.injector.getInstance(Coordinator.class)).stop();
        ((ClusterService)this.injector.getInstance(ClusterService.class)).stop();
        ((NodeConnectionsService)this.injector.getInstance(NodeConnectionsService.class)).stop();
        ((FsHealthService)this.injector.getInstance(FsHealthService.class)).stop();
        this.nodeService.getMonitorService().stop();
        ((GatewayService)this.injector.getInstance(GatewayService.class)).stop();
        ((TransportService)this.injector.getInstance(TransportService.class)).stop();
        ((DecommissioningService)this.injector.getInstance(DecommissioningService.class)).stop();
        ((JobsLogService)this.injector.getInstance(JobsLogService.class)).stop();
        ((PostgresNetty)this.injector.getInstance(PostgresNetty.class)).stop();
        ((TasksService)this.injector.getInstance(TasksService.class)).stop();
        ((DanglingArtifactsService)this.injector.getInstance(DanglingArtifactsService.class)).stop();
        ((SslContextProviderService)this.injector.getInstance(SslContextProviderService.class)).stop();
        ((BlobService)this.injector.getInstance(BlobService.class)).stop();
        if (UDCService.UDC_ENABLED_SETTING.get(this.settings).booleanValue()) {
            ((UDCService)this.injector.getInstance(UDCService.class)).stop();
        }
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        ((IndicesService)this.injector.getInstance(IndicesService.class)).stop();
        ((NettyBootstrap)this.injector.getInstance(NettyBootstrap.class)).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add((Closeable)this.injector.getInstance(HttpServerTransport.class));
        toClose.add(() -> stopWatch.stop().start("logical_replication_service"));
        toClose.add((Closeable)this.injector.getInstance(LogicalReplicationService.class));
        toClose.add(() -> stopWatch.stop().start("logical_replication_shard_service"));
        toClose.add((Closeable)this.injector.getInstance(ShardReplicationService.class));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add((Closeable)this.injector.getInstance(SnapshotsService.class));
        toClose.add((Closeable)this.injector.getInstance(SnapshotShardsService.class));
        toClose.add((Closeable)this.injector.getInstance(RepositoriesService.class));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close((Releasable)this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add((Closeable)this.injector.getInstance(IndicesClusterStateService.class));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add((Closeable)this.injector.getInstance(IndicesService.class));
        toClose.add((Closeable)this.injector.getInstance(IndicesStore.class));
        toClose.add((Closeable)this.injector.getInstance(PeerRecoverySourceService.class));
        toClose.add(() -> stopWatch.stop().start("remote_clusters"));
        toClose.add((Closeable)this.injector.getInstance(RemoteClusters.class));
        toClose.add(() -> stopWatch.stop().start("routing"));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add((Closeable)this.injector.getInstance(ClusterService.class));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add((Closeable)this.injector.getInstance(NodeConnectionsService.class));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add((Closeable)this.injector.getInstance(Coordinator.class));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.nodeService.getMonitorService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add((Closeable)this.injector.getInstance(FsHealthService.class));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add((Closeable)this.injector.getInstance(GatewayService.class));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add((Closeable)this.injector.getInstance(TransportService.class));
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add((Closeable)this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add((Closeable)this.injector.getInstance(NodeEnvironment.class));
        toClose.add(() -> stopWatch.stop().start("decommission_service"));
        toClose.add((Closeable)this.injector.getInstance(DecommissioningService.class));
        toClose.add(() -> stopWatch.stop().start("jobs_log_service"));
        toClose.add((Closeable)this.injector.getInstance(JobsLogService.class));
        toClose.add(() -> stopWatch.stop().start("postgres_netty"));
        toClose.add((Closeable)this.injector.getInstance(PostgresNetty.class));
        toClose.add(() -> stopWatch.stop().start("tasks_service"));
        toClose.add((Closeable)this.injector.getInstance(TasksService.class));
        toClose.add(() -> stopWatch.stop().start("dangling_artifacts_service"));
        toClose.add((Closeable)this.injector.getInstance(DanglingArtifactsService.class));
        toClose.add(() -> stopWatch.stop().start("ssl_context_provider_service"));
        toClose.add((Closeable)this.injector.getInstance(SslContextProviderService.class));
        toClose.add(() -> stopWatch.stop().start("blob_service"));
        toClose.add((Closeable)this.injector.getInstance(BlobService.class));
        toClose.add(() -> stopWatch.stop().start("netty_bootstrap"));
        toClose.add((Closeable)this.injector.getInstance(NettyBootstrap.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> ((ThreadPool)this.injector.getInstance(ThreadPool.class)).shutdown());
        toClose.add(() -> stopWatch.stop());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint());
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = (ThreadPool)this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsFile().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsFile().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings);
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, client);
        if (DiscoveryNode.isMasterEligibleNode(settings)) {
            clusterService.addListener(service);
        }
        return service;
    }

    protected HttpServerTransport newHttpTransport(NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, SslContextProvider sslContextProvider, BlobService blobService, Sessions sessions, Authentication authentication, Roles roles, CircuitBreakerService breakerService, NodeClient nodeClient) {
        return new Netty4HttpServerTransport(this.settings, networkService, bigArrays, threadPool, xContentRegistry, sslContextProvider, blobService, sessions, authentication, roles, breakerService, nodeClient);
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;
        @Nullable
        String httpPublishAddress;

        private LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            HashMap<String, String> attributes = new HashMap<String, String>(NODE_ATTRIBUTES.getAsMap(this.settings));
            Set<DiscoveryNodeRole> roles = DiscoveryNode.getRolesFromSettings(this.settings);
            if (this.httpPublishAddress != null) {
                attributes.put("http_address", this.httpPublishAddress);
            }
            this.localNode.set((Object)new DiscoveryNode(NODE_NAME_SETTING.get(this.settings), this.persistentNodeId, boundTransportAddress.publishAddress(), attributes, roles, Version.CURRENT));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }
}

