/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.concurrent.FutureActionListener;
import io.crate.replication.logical.metadata.ConnectionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.state.TransportClusterState;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.ProxyConnection;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.transport.RemoteConnectionParser;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.jetbrains.annotations.Nullable;

public final class SniffRemoteClient
implements Client {
    private final TransportService transportService;
    private final ConnectionProfile profile;
    private final List<Supplier<DiscoveryNode>> seedNodes;
    private final String clusterAlias;
    private final SetOnce<ClusterName> remoteClusterName = new SetOnce();
    private final Predicate<ClusterName> allNodesShareClusterName;
    private CompletableFuture<DiscoveredNodes> discoveredNodes = null;

    public SniffRemoteClient(Settings nodeSettings, ConnectionInfo connectionInfo, String clusterAlias, TransportService transportService) {
        this.clusterAlias = clusterAlias;
        this.transportService = transportService;
        this.seedNodes = Lists.map(connectionInfo.hosts(), seedNode -> () -> SniffRemoteClient.resolveSeedNode(clusterAlias, seedNode));
        this.profile = new ConnectionProfile.Builder().setConnectTimeout(TransportSettings.CONNECT_TIMEOUT.get(nodeSettings)).setHandshakeTimeout(TransportSettings.CONNECT_TIMEOUT.get(nodeSettings)).setPingInterval(TransportSettings.PING_SCHEDULE.get(nodeSettings)).setCompressionEnabled(TransportSettings.TRANSPORT_COMPRESS.get(nodeSettings)).addConnections(1, TransportRequestOptions.Type.BULK).addConnections(0, TransportRequestOptions.Type.PING).addConnections(1, TransportRequestOptions.Type.STATE).addConnections(1, TransportRequestOptions.Type.RECOVERY).addConnections(1, TransportRequestOptions.Type.REG).build();
        this.allNodesShareClusterName = c -> {
            ClusterName clusterName = (ClusterName)this.remoteClusterName.get();
            return clusterName == null || c.equals(clusterName);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SniffRemoteClient sniffRemoteClient = this;
        synchronized (sniffRemoteClient) {
            if (this.discoveredNodes == null) {
                return;
            }
            if (this.discoveredNodes.isCompletedExceptionally()) {
                this.discoveredNodes = null;
                return;
            }
            this.discoveredNodes.thenAccept(nodes -> {
                DiscoveredNodes discoveredNodes = nodes;
                synchronized (discoveredNodes) {
                    Iterator<Map.Entry<DiscoveryNode, CompletableFuture<Transport.Connection>>> it = nodes.connections.entrySet().iterator();
                    while (it.hasNext()) {
                        DiscoveryNode node = it.next().getKey();
                        this.transportService.disconnectFromNode(node);
                        it.remove();
                    }
                }
            });
            this.discoveredNodes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Transport.Connection> getAnyConnection(DiscoveredNodes discoveredNodes) {
        Object object = discoveredNodes;
        synchronized (object) {
            Iterator<Map.Entry<DiscoveryNode, CompletableFuture<Transport.Connection>>> it = discoveredNodes.connections.entrySet().iterator();
            ArrayList<Transport.Connection> closedConnections = new ArrayList<Transport.Connection>();
            while (it.hasNext()) {
                Map.Entry<DiscoveryNode, CompletableFuture<Transport.Connection>> entry = it.next();
                CompletableFuture<Transport.Connection> connection = entry.getValue();
                if (connection.isCompletedExceptionally()) {
                    it.remove();
                    continue;
                }
                if (connection.isDone() && connection.join().isClosed()) {
                    closedConnections.add(connection.join());
                    it.remove();
                    continue;
                }
                return connection;
            }
            if (!closedConnections.isEmpty()) {
                Transport.Connection conn = (Transport.Connection)closedConnections.iterator().next();
                DiscoveryNode node = conn.getNode();
                CompletableFuture<Transport.Connection> newConn = this.connectWithHandshake(node);
                discoveredNodes.connections.put(node, newConn);
                return newConn;
            }
        }
        object = this;
        synchronized (object) {
            this.discoveredNodes = null;
            return this.ensureConnected(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Transport.Connection> getConnection(DiscoveredNodes nodes, DiscoveryNode preferredNode) {
        DiscoveredNodes discoveredNodes = nodes;
        synchronized (discoveredNodes) {
            CompletableFuture<Transport.Connection> conn = nodes.connections.get(preferredNode);
            if (conn == null || conn.isCompletedExceptionally() || conn.isDone() && conn.join().isClosed()) {
                if (nodes.hasDiscovered(preferredNode)) {
                    CompletableFuture<Transport.Connection> newConn = this.connectWithHandshake(preferredNode);
                    nodes.connections.put(preferredNode, newConn);
                    return newConn;
                }
                return this.getAnyConnection(nodes).thenApply(c -> new ProxyConnection((Transport.Connection)c, preferredNode));
            }
            return conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Transport.Connection> ensureConnected(@Nullable DiscoveryNode preferredNode) {
        SniffRemoteClient sniffRemoteClient = this;
        synchronized (sniffRemoteClient) {
            if (this.discoveredNodes == null) {
                this.discoveredNodes = this.discoverNodes();
            } else if (this.discoveredNodes.isCompletedExceptionally()) {
                this.discoveredNodes = this.discoverNodes();
            }
            return this.discoveredNodes.thenCompose(nodes -> {
                if (preferredNode == null) {
                    return this.getAnyConnection((DiscoveredNodes)nodes);
                }
                return this.getConnection((DiscoveredNodes)nodes, preferredNode);
            });
        }
    }

    private CompletableFuture<DiscoveredNodes> discoverNodes() {
        return this.tryConnectToAnySeedNode(this.seedNodes.iterator()).thenCompose(this::discoverNodes);
    }

    private CompletableFuture<DiscoveredNodes> discoverNodes(final Transport.Connection connection) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.clear();
        request.nodes(true);
        request.local(true);
        final CompletableFuture<DiscoveredNodes> result = new CompletableFuture<DiscoveredNodes>();
        this.transportService.sendRequest(connection, TransportClusterState.ACTION.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new TransportResponseHandler<ClusterStateResponse>(){

            @Override
            public ClusterStateResponse read(StreamInput in) throws IOException {
                return new ClusterStateResponse(in);
            }

            @Override
            public void handleResponse(ClusterStateResponse response) {
                DiscoveryNodes nodes = response.getState().nodes();
                result.complete(new DiscoveredNodes(connection, nodes));
            }

            @Override
            public void handleException(TransportException exp) {
                connection.close();
                result.completeExceptionally(exp.unwrapCause());
            }

            @Override
            public String executor() {
                return "same";
            }
        });
        return result;
    }

    private CompletableFuture<Transport.Connection> tryConnectToAnySeedNode(Iterator<Supplier<DiscoveryNode>> seedNodes) {
        if (seedNodes.hasNext()) {
            try {
                DiscoveryNode seedNode = seedNodes.next().get();
                return this.connectWithHandshake(seedNode).exceptionallyCompose(err -> {
                    if (seedNodes.hasNext()) {
                        return this.tryConnectToAnySeedNode(seedNodes);
                    }
                    throw Exceptions.toRuntimeException((Throwable)err);
                });
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        }
        return CompletableFuture.failedFuture(new NoSuchRemoteClusterException(this.clusterAlias));
    }

    private CompletableFuture<Transport.Connection> connectWithHandshake(DiscoveryNode node) {
        FutureActionListener<Transport.Connection> openedConnection = new FutureActionListener<Transport.Connection>();
        this.transportService.openConnection(node, this.profile, openedConnection);
        CompletionStage receivedHandshakeResponse = openedConnection.thenCompose(connection -> {
            FutureActionListener<TransportService.HandshakeResponse> handshakeResponse = new FutureActionListener<TransportService.HandshakeResponse>();
            this.transportService.handshake((Transport.Connection)connection, this.profile.getHandshakeTimeout().millis(), this.allNodesShareClusterName, (ActionListener<TransportService.HandshakeResponse>)handshakeResponse);
            return handshakeResponse;
        });
        return ((CompletableFuture)receivedHandshakeResponse).thenCompose(handshakeResponse -> {
            DiscoveryNode handshakeNode = handshakeResponse.getDiscoveryNode();
            if (!SniffRemoteClient.nodeIsCompatible(handshakeNode)) {
                throw new IllegalStateException("Remote publisher node [" + String.valueOf(handshakeNode) + "] is not compatible with subscriber node (" + String.valueOf(this.transportService.localNode) + "). The publisher node must have a compatible version and needs to be a data node");
            }
            this.remoteClusterName.trySet((Object)handshakeResponse.getClusterName());
            FutureActionListener<Void> connectedListener = new FutureActionListener<Void>();
            this.transportService.connectToNode(handshakeNode, connectedListener);
            return connectedListener.thenApply(ignored -> (Transport.Connection)openedConnection.join());
        });
    }

    private static boolean nodeIsCompatible(DiscoveryNode node) {
        return Version.CURRENT.isCompatible(node.getVersion()) && (!node.isMasterEligibleNode() || node.isDataNode());
    }

    @Override
    public <Req extends TransportRequest, Resp extends TransportResponse> CompletableFuture<Resp> execute(ActionType<Resp> action, Req request) {
        DiscoveryNode discoveryNode;
        if (request instanceof RemoteClusterAwareRequest) {
            RemoteClusterAwareRequest remoteClusterAware = (RemoteClusterAwareRequest)((Object)request);
            discoveryNode = remoteClusterAware.getPreferredTargetNode();
        } else {
            discoveryNode = null;
        }
        DiscoveryNode targetNode = discoveryNode;
        return this.ensureConnected(targetNode).thenCompose(conn -> {
            FutureActionListener future = new FutureActionListener();
            Transport.Connection connection = targetNode == null ? conn : new ProxyConnection((Transport.Connection)conn, targetNode);
            this.transportService.sendRequest(connection, action.name(), request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(action.name(), future, action.getResponseReader()));
            return future;
        });
    }

    private static DiscoveryNode resolveSeedNode(String clusterAlias, String address) {
        TransportAddress transportAddress = new TransportAddress(RemoteConnectionParser.parseConfiguredAddress(address));
        return new DiscoveryNode("sniff_to=" + clusterAlias + "#" + transportAddress.toString(), transportAddress, Version.CURRENT.minimumCompatibilityVersion());
    }

    static class DiscoveredNodes {
        private final HashMap<DiscoveryNode, CompletableFuture<Transport.Connection>> connections = new HashMap();
        private final DiscoveryNodes discoveryNodes;

        DiscoveredNodes(Transport.Connection connection, DiscoveryNodes discoveryNodes) {
            this.connections.put(connection.getNode(), CompletableFuture.completedFuture(connection));
            this.discoveryNodes = discoveryNodes;
        }

        public boolean hasDiscovered(DiscoveryNode preferredNode) {
            return this.discoveryNodes.nodeExists(preferredNode);
        }
    }
}

