/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.protocols.ConnectionStats;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;

public class StatsTracker {
    private final CounterMetric openChannelsMetric = new CounterMetric();
    private final CounterMetric totalChannelsMetric = new CounterMetric();
    private final LongAdder bytesReceivedMetric = new LongAdder();
    private final CounterMetric messagesReceivedMetric = new CounterMetric();
    private final MeanMetric bytesSentMetric = new MeanMetric();

    public void incrementOpenChannels() {
        this.openChannelsMetric.inc();
        this.totalChannelsMetric.inc();
    }

    public void decrementOpenChannels() {
        this.openChannelsMetric.dec();
    }

    public void incrementBytesReceived(long bytesReceived) {
        this.bytesReceivedMetric.add(bytesReceived);
    }

    public void incrementMessagesReceived() {
        this.messagesReceivedMetric.inc();
    }

    public void incrementBytesSent(long bytesSent) {
        this.bytesSentMetric.inc(bytesSent);
    }

    public long openConnections() {
        return this.openChannelsMetric.count();
    }

    public long totalConnections() {
        return this.totalChannelsMetric.count();
    }

    public long messagesReceived() {
        return this.messagesReceivedMetric.count();
    }

    public long bytesReceived() {
        return this.bytesReceivedMetric.sum();
    }

    public long bytesSent() {
        return this.bytesSentMetric.sum();
    }

    public long messagesSent() {
        return this.bytesSentMetric.count();
    }

    public ConnectionStats stats() {
        return new ConnectionStats(this.openConnections(), this.totalConnections(), this.messagesReceived(), this.bytesReceived(), this.messagesSent(), this.bytesSent());
    }
}

