/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.transport.StatsTracker;

@ChannelHandler.Sharable
public class Netty4OutboundStatsHandler
extends ChannelOutboundHandlerAdapter
implements Releasable {
    private final StatsTracker statsTracker;
    final Logger logger;

    public Netty4OutboundStatsHandler(StatsTracker statsTracker, Logger logger) {
        this.statsTracker = statsTracker;
        this.logger = logger;
    }

    @Override
    public void close() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf bb = (ByteBuf)msg;
            this.statsTracker.incrementBytesSent(bb.readableBytes());
        } else {
            this.logger.warn("Message received is: {} and not a ByteBuf, cannot track sent bytes or message count", (Object)msg.getClass().getCanonicalName());
        }
        ctx.write(msg, promise);
    }
}

