/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.ConditionalBackReferenceGroup;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class RegexASTNode
implements JsonConvertible {
    static final int FLAG_PREFIX = 1;
    static final int FLAG_DEAD = 2;
    static final int FLAG_HAS_CARET = 4;
    static final int FLAG_HAS_DOLLAR = 8;
    static final int FLAG_STARTS_WITH_CARET = 16;
    static final int FLAG_ENDS_WITH_DOLLAR = 32;
    static final int FLAG_BACK_REFERENCE_IS_NESTED = 64;
    static final int FLAG_BACK_REFERENCE_IS_FORWARD = 128;
    static final int FLAG_BACK_REFERENCE_IS_NESTED_OR_FORWARD = 256;
    static final int FLAG_BACK_REFERENCE_IS_IGNORE_CASE = 512;
    static final int FLAG_BACK_REFERENCE_IS_IGNORE_CASE_ALTERNATIVE_MODE = 1024;
    static final int FLAG_MAY_MATCH_EMPTY_STRING = 2048;
    static final int FLAG_GROUP_LOOP = 4096;
    static final int FLAG_GROUP_EXPANDED_QUANTIFIER = 8192;
    static final int FLAG_GROUP_MANDATORY_QUANTIFIER = 16384;
    static final int FLAG_GROUP_OPTIONAL_QUANTIFIER = 32768;
    static final int FLAG_GROUP_QUANTIFIER_PASS_THROUGH_SEQUENCE = 65536;
    static final int FLAG_GROUP_LOCAL_FLAGS = 131072;
    static final int FLAG_EMPTY_GUARD = 262144;
    static final int FLAG_LOOK_AROUND_NEGATED = 524288;
    static final int FLAG_HAS_ATOMIC_GROUPS = 0x100000;
    static final int FLAG_HAS_LOOPS = 0x200000;
    static final int FLAG_HAS_CAPTURE_GROUPS = 0x400000;
    static final int FLAG_HAS_QUANTIFIERS = 0x800000;
    static final int FLAG_HAS_LOOK_BEHINDS = 0x1000000;
    static final int FLAG_HAS_LOOK_AHEADS = 0x2000000;
    static final int FLAG_HAS_BACK_REFERENCES = 0x4000000;
    static final int FLAG_CHARACTER_CLASS_WAS_SINGLE_CHAR = 0x8000000;
    private int id = -1;
    private RegexASTNode parent;
    private int flags;
    private int minPath = 0;
    private int maxPath = 0;
    private int prefixLengthMin = 0;
    private int prefixLengthMax = 0;

    protected RegexASTNode() {
    }

    protected RegexASTNode(RegexASTNode copy) {
        this.flags = copy.flags;
        this.minPath = copy.minPath;
        this.maxPath = copy.maxPath;
    }

    public abstract RegexASTNode copy(RegexAST var1);

    public abstract RegexASTNode copyRecursive(RegexAST var1, CompilationBuffer var2);

    public abstract boolean equalsSemantic(RegexASTNode var1);

    public boolean idInitialized() {
        return this.id >= 0;
    }

    public final int getId() {
        assert (this.idInitialized());
        return this.id;
    }

    public final void setId(int id) {
        assert (!this.idInitialized());
        assert (id <= Integer.MAX_VALUE);
        this.id = id;
    }

    public RegexASTNode getParent() {
        return this.parent;
    }

    public void setParent(RegexASTNode parent) {
        this.parent = parent;
    }

    protected boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    protected boolean areAllFlagsSet(int multipleFlags) {
        return (this.flags & multipleFlags) == multipleFlags;
    }

    protected void setFlag(int flag) {
        this.setFlag(flag, true);
    }

    protected int getFlags(int mask) {
        return this.flags & mask;
    }

    protected void setFlags(int newFlags, int mask) {
        assert ((newFlags & ~mask) == 0);
        this.flags = this.flags & ~mask | newFlags;
    }

    protected void clearFlags(int mask) {
        this.flags &= ~mask;
    }

    protected void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void markAsDead() {
        this.setDead(true);
    }

    public void setDead(boolean dead) {
        this.setFlag(2, dead);
    }

    public boolean isDead() {
        return this.isFlagSet(2);
    }

    public boolean isPrefix() {
        return this.isFlagSet(1);
    }

    public void setPrefix() {
        this.setFlag(1);
    }

    public boolean hasEmptyGuard() {
        return this.isFlagSet(262144);
    }

    public void setEmptyGuard(boolean emptyGuard) {
        this.setFlag(262144, emptyGuard);
    }

    public boolean mayMatchEmptyString() {
        return this.isFlagSet(2048);
    }

    public void setMayMatchEmptyString(boolean value) {
        this.setFlag(2048, value);
    }

    public boolean hasCaret() {
        return this.isFlagSet(4);
    }

    public void setHasCaret() {
        this.setHasCaret(true);
    }

    public void setHasCaret(boolean hasCaret) {
        this.setFlag(4, hasCaret);
    }

    public boolean hasDollar() {
        return this.isFlagSet(8);
    }

    public void setHasDollar() {
        this.setHasDollar(true);
    }

    public void setHasDollar(boolean hasDollar) {
        this.setFlag(8, hasDollar);
    }

    public boolean startsWithCaret() {
        return this.isFlagSet(16);
    }

    public void setStartsWithCaret() {
        this.setStartsWithCaret(true);
    }

    public void setStartsWithCaret(boolean startsWithCaret) {
        this.setFlag(16, startsWithCaret);
    }

    public boolean endsWithDollar() {
        return this.isFlagSet(32);
    }

    public void setEndsWithDollar() {
        this.setEndsWithDollar(true);
    }

    public void setEndsWithDollar(boolean endsWithDollar) {
        this.setFlag(32, endsWithDollar);
    }

    public boolean hasAtomicGroups() {
        return this.isFlagSet(0x100000);
    }

    public void setHasAtomicGroups() {
        this.setHasAtomicGroups(true);
    }

    public void setHasAtomicGroups(boolean hasAtomicGroups) {
        this.setFlag(0x100000, hasAtomicGroups);
    }

    public boolean hasLoops() {
        return this.isFlagSet(0x200000);
    }

    public void setHasLoops() {
        this.setHasLoops(true);
    }

    public void setHasLoops(boolean hasLoops) {
        this.setFlag(0x200000, hasLoops);
    }

    public boolean hasQuantifiers() {
        return this.isFlagSet(0x800000);
    }

    public void setHasQuantifiers() {
        this.setFlag(0x800000, true);
    }

    public boolean hasCaptureGroups() {
        return this.isFlagSet(0x400000);
    }

    public void setHasCaptureGroups() {
        this.setFlag(0x400000, true);
    }

    public boolean hasLookAheads() {
        return this.isFlagSet(0x2000000);
    }

    public void setHasLookAheads() {
        this.setFlag(0x2000000, true);
    }

    public boolean hasLookBehinds() {
        return this.isFlagSet(0x1000000);
    }

    public void setHasLookBehinds() {
        this.setFlag(0x1000000, true);
    }

    public boolean hasLookArounds() {
        return this.isFlagSet(0x3000000);
    }

    public boolean hasBackReferences() {
        return this.isFlagSet(0x4000000);
    }

    public void setHasBackReferences() {
        this.setFlag(0x4000000, true);
    }

    public boolean isExpandedQuantifier() {
        return this.isFlagSet(8192);
    }

    public void setExpandedQuantifier(boolean expandedQuantifier) {
        this.setFlag(8192, expandedQuantifier);
    }

    public boolean isMandatoryQuantifier() {
        return this.isFlagSet(16384);
    }

    public void setMandatoryQuantifier(boolean mandatoryQuantifier) {
        this.setFlag(16384, mandatoryQuantifier);
    }

    public boolean isOptionalQuantifier() {
        return this.isFlagSet(32768);
    }

    public void setOptionalQuantifier(boolean optionalQuantifier) {
        this.setFlag(32768, optionalQuantifier);
    }

    public boolean isMandatoryUnrolledQuantifier() {
        return this.areAllFlagsSet(24576);
    }

    public boolean isQuantifierPassThroughSequence() {
        return this.isFlagSet(65536);
    }

    public void setQuantifierPassThroughSequence(boolean quantifierPassThroughSequence) {
        this.setFlag(65536, quantifierPassThroughSequence);
    }

    public int getMinPath() {
        return this.minPath;
    }

    public void setMinPath(int n) {
        this.minPath = n;
    }

    public void incMinPath() {
        this.incMinPath(1);
    }

    public void incMinPath(int n) {
        this.minPath += n;
    }

    public int getMaxPath() {
        return this.maxPath;
    }

    public void setMaxPath(int n) {
        this.maxPath = n;
    }

    public void incMaxPath() {
        this.incMaxPath(1);
    }

    public void incMaxPath(int n) {
        this.maxPath += n;
    }

    public int getPrefixLengthMin() {
        return this.prefixLengthMin;
    }

    public void setPrefixLengthMin(int prefixLengthMin) {
        this.prefixLengthMin = prefixLengthMin;
    }

    public int getPrefixLengthMax() {
        return this.prefixLengthMax;
    }

    public void setPrefixLengthMax(int prefixLengthMax) {
        this.prefixLengthMax = prefixLengthMax;
    }

    public boolean hasVariablePrefixLength() {
        return this.getPrefixLengthMin() != this.getPrefixLengthMax();
    }

    public abstract RegexASTSubtreeRootNode getSubTreeParent();

    public boolean isInLookBehindAssertion() {
        return this.getSubTreeParent() instanceof LookBehindAssertion;
    }

    public boolean isInLookAheadAssertion() {
        return this.getSubTreeParent() instanceof LookAheadAssertion;
    }

    public boolean isInLookAroundAssertion() {
        return this.getSubTreeParent() instanceof LookAroundAssertion;
    }

    public String toStringWithID() {
        return String.format("%d (%s)", this.id, this.toString());
    }

    protected static JsonValue astNodeId(RegexASTNode astNode) {
        return astNode == null ? Json.nullValue() : Json.val(astNode.id);
    }

    public boolean isBackReference() {
        return this instanceof BackReference;
    }

    public boolean isCharacterClass() {
        return this instanceof CharacterClass;
    }

    public boolean isGroup() {
        return this instanceof Group;
    }

    public boolean isGroupWithGuards() {
        return this.isGroup() && this.asGroup().hasGroupWithGuardsIndex();
    }

    public boolean isConditionalBackReferenceGroup() {
        return this instanceof ConditionalBackReferenceGroup;
    }

    public boolean isLookAroundAssertion() {
        return this instanceof LookAroundAssertion;
    }

    public boolean isLookAheadAssertion() {
        return this instanceof LookAheadAssertion;
    }

    public boolean isLookBehindAssertion() {
        return this instanceof LookBehindAssertion;
    }

    public boolean isAtomicGroup() {
        return this instanceof AtomicGroup;
    }

    public boolean isMatchFound() {
        return this instanceof MatchFound;
    }

    public boolean isPositionAssertion() {
        return this instanceof PositionAssertion;
    }

    public boolean isQuantifiableTerm() {
        return this instanceof QuantifiableTerm;
    }

    public boolean isSubexpressionCall() {
        return this instanceof SubexpressionCall;
    }

    public boolean isRoot() {
        return this instanceof RegexASTRootNode;
    }

    public boolean isSubtreeRoot() {
        return this instanceof RegexASTSubtreeRootNode;
    }

    public boolean isSequence() {
        return this instanceof Sequence;
    }

    public boolean isCaret() {
        return this.isPositionAssertion() && this.asPositionAssertion().isCaret();
    }

    public boolean isDollar() {
        return this.isPositionAssertion() && this.asPositionAssertion().isDollar();
    }

    public BackReference asBackReference() {
        return (BackReference)this;
    }

    public CharacterClass asCharacterClass() {
        return (CharacterClass)this;
    }

    public Group asGroup() {
        return (Group)this;
    }

    public ConditionalBackReferenceGroup asConditionalBackReferenceGroup() {
        return (ConditionalBackReferenceGroup)this;
    }

    public LookAroundAssertion asLookAroundAssertion() {
        return (LookAroundAssertion)this;
    }

    public LookAheadAssertion asLookAheadAssertion() {
        return (LookAheadAssertion)this;
    }

    public LookBehindAssertion asLookBehindAssertion() {
        return (LookBehindAssertion)this;
    }

    public AtomicGroup asAtomicGroup() {
        return (AtomicGroup)this;
    }

    public RegexASTSubtreeRootNode asSubtreeRootNode() {
        return (RegexASTSubtreeRootNode)this;
    }

    public MatchFound asMatchFound() {
        return (MatchFound)this;
    }

    public PositionAssertion asPositionAssertion() {
        return (PositionAssertion)this;
    }

    public QuantifiableTerm asQuantifiableTerm() {
        return (QuantifiableTerm)this;
    }

    public Sequence asSequence() {
        return (Sequence)this;
    }

    public SubexpressionCall asSubexpressionCall() {
        return (SubexpressionCall)this;
    }

    protected JsonObject toJson(String typeName) {
        return Json.obj(Json.prop("id", this.id), Json.prop("type", typeName), Json.prop("parent", RegexASTNode.astNodeId(this.parent)), Json.prop("minPath", this.minPath), Json.prop("maxPath", this.maxPath), Json.prop("prefixLengthMin", this.prefixLengthMin), Json.prop("prefixLengthMax", this.prefixLengthMax), Json.prop("isPrefix", this.isPrefix()), Json.prop("isDead", this.isDead()));
    }
}

