/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.copy.azure.AzureURI;
import io.crate.copy.azure.OperatorHelper;
import io.crate.copy.azure.SharedAsyncExecutor;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.export.FileOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;
import org.apache.opendal.AsyncExecutor;
import org.apache.opendal.AsyncOperator;
import org.apache.opendal.Operator;
import org.elasticsearch.common.settings.Settings;

public class AzureFileOutput
implements FileOutput {
    private final Map<String, String> config;
    private final Operator operator;
    private final String resourcePath;
    private static final int MAX_BYTES = 262144;

    public AzureFileOutput(URI uri, SharedAsyncExecutor sharedAsyncExecutor, Settings settings) {
        AzureURI azureURI = AzureURI.of(uri);
        this.config = OperatorHelper.config(azureURI, settings, false);
        this.resourcePath = azureURI.resourcePath();
        this.operator = AsyncOperator.of((String)"azblob", this.config, (AsyncExecutor)sharedAsyncExecutor.asyncExecutor()).blocking();
    }

    public OutputStream acquireOutputStream(Executor executor, WriterProjection.CompressionType compressionType) throws IOException {
        Object outputStream = this.operator.createOutputStream(this.resourcePath, 262144);
        if (compressionType != null) {
            outputStream = new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public void close() {
        assert (this.operator != null) : "Operator must be created before FileOutput is closed";
        this.operator.close();
    }
}

